/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DistinctLimitOperator;
import io.trino.operator.DriverContext;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHashYieldAssertion;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDistinctLimitOperator {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    private final FlatHashStrategyCompiler hashStrategyCompiler = new FlatHashStrategyCompiler(new TypeOperators());

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testDistinctLimit() {
        this.testDistinctLimit(true);
        this.testDistinctLimit(false);
    }

    public void testDistinctLimit(boolean hashEnabled) {
        DriverContext driverContext = this.newDriverContext();
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 1).addSequencePage(5, 2).build();
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), 5L, rowPagesBuilder.getHashChannel(), this.hashStrategyCompiler);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{2L}).row(new Object[]{3L}).row(new Object[]{4L}).row(new Object[]{5L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)1));
    }

    @Test
    public void testDistinctLimitWithPageAlignment() {
        this.testDistinctLimitWithPageAlignment(true);
        this.testDistinctLimitWithPageAlignment(false);
    }

    public void testDistinctLimitWithPageAlignment(boolean hashEnabled) {
        DriverContext driverContext = this.newDriverContext();
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 1).addSequencePage(3, 2).build();
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), 3L, rowPagesBuilder.getHashChannel(), this.hashStrategyCompiler);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{2L}).row(new Object[]{3L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)1));
    }

    @Test
    public void testDistinctLimitValuesLessThanLimit() {
        this.testDistinctLimitValuesLessThanLimit(true);
        this.testDistinctLimitValuesLessThanLimit(false);
    }

    public void testDistinctLimitValuesLessThanLimit(boolean hashEnabled) {
        DriverContext driverContext = this.newDriverContext();
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 1).addSequencePage(3, 2).build();
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), 5L, rowPagesBuilder.getHashChannel(), this.hashStrategyCompiler);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{2L}).row(new Object[]{3L}).row(new Object[]{4L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)1));
    }

    @Test
    public void testMemoryReservationYield() {
        this.testMemoryReservationYield((Type)VarcharType.VARCHAR);
        this.testMemoryReservationYield((Type)BigintType.BIGINT);
    }

    public void testMemoryReservationYield(Type type) {
        List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys(type, 6000, 600);
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)type, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0), Integer.MAX_VALUE, Optional.of(1), this.hashStrategyCompiler);
        GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, type, (OperatorFactory)operatorFactory, operator -> ((DistinctLimitOperator)operator).getCapacity(), 450000L);
        io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(5));
        io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x1400000L));
        Assertions.assertThat((int)result.getOutput().stream().mapToInt(Page::getPositionCount).sum()).isEqualTo(3600000);
    }

    private DriverContext newDriverContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }
}

