/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHashYieldAssertion;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.RowNumberOperator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestRowNumberOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private final FlatHashStrategyCompiler hashStrategyCompiler = new FlatHashStrategyCompiler(new TypeOperators());

    @BeforeAll
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    private DriverContext getDriverContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @Test
    public void testRowNumberUnpartitioned() {
        DriverContext driverContext = this.getDriverContext();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.19).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).row(2L, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), 10, this.hashStrategyCompiler);
        MaterializedResult expectedResult = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.3, 1L}).row(new Object[]{0.4, 1L}).row(new Object[]{0.5, 1L}).row(new Object[]{0.6, 1L}).row(new Object[]{0.2, 2L}).row(new Object[]{0.7, 2L}).row(new Object[]{0.8, 2L}).row(new Object[]{0.9, 2L}).row(new Object[]{0.1, 3L}).row(new Object[]{0.19, 3L}).build();
        List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assertions.assertThat((int)rowNumberColumn.getPositionCount()).isEqualTo(10);
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expectedResult.getMaterializedRows());
    }

    @Test
    public void testMemoryReservationYield() {
        for (Type type : Arrays.asList(VarcharType.VARCHAR, BigintType.BIGINT)) {
            List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys(type, 6000, 600);
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)type), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)type), Optional.empty(), Optional.of(1), 1, this.hashStrategyCompiler);
            GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, type, (OperatorFactory)operatorFactory, operator -> ((RowNumberOperator)operator).getCapacity(), 280000L);
            io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(5));
            io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x1400000L));
            int count = 0;
            for (Page page : result.getOutput()) {
                Assertions.assertThat((int)page.getChannelCount()).isEqualTo(3);
                for (int i = 0; i < page.getPositionCount(); ++i) {
                    Assertions.assertThat((long)BigintType.BIGINT.getLong(page.getBlock(2), i)).isEqualTo(1L);
                    ++count;
                }
            }
            Assertions.assertThat((int)count).isEqualTo(3600000);
        }
    }

    @Test
    public void testRowNumberPartitioned() {
        for (boolean hashEnabled : Arrays.asList(true, false)) {
            DriverContext driverContext = this.getDriverContext();
            RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT, DoubleType.DOUBLE});
            List<Page> input = rowPagesBuilder.row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.19).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).row(2L, 0.9).build();
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.of(10), rowPagesBuilder.getHashChannel(), 10, this.hashStrategyCompiler);
            MaterializedResult expectedPartition1 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.3, 1L}).row(new Object[]{0.4, 1L}).row(new Object[]{0.5, 1L}).row(new Object[]{0.6, 1L}).build();
            MaterializedResult expectedPartition2 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.2, 2L}).row(new Object[]{0.7, 2L}).row(new Object[]{0.8, 2L}).row(new Object[]{0.9, 2L}).build();
            MaterializedResult expectedPartition3 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.1, 3L}).row(new Object[]{0.19, 3L}).build();
            List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
            Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
            Assertions.assertThat((int)rowNumberColumn.getPositionCount()).isEqualTo(10);
            pages = TestRowNumberOperator.stripRowNumberColumn(pages);
            MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
            ImmutableSet actualSet = ImmutableSet.copyOf((Collection)actual.getMaterializedRows());
            ImmutableSet expectedPartition1Set = ImmutableSet.copyOf((Collection)expectedPartition1.getMaterializedRows());
            ImmutableSet expectedPartition2Set = ImmutableSet.copyOf((Collection)expectedPartition2.getMaterializedRows());
            ImmutableSet expectedPartition3Set = ImmutableSet.copyOf((Collection)expectedPartition3.getMaterializedRows());
            Assertions.assertThat((int)Sets.intersection((Set)expectedPartition1Set, (Set)actualSet).size()).isEqualTo(4);
            Assertions.assertThat((int)Sets.intersection((Set)expectedPartition2Set, (Set)actualSet).size()).isEqualTo(4);
            Assertions.assertThat((int)Sets.intersection((Set)expectedPartition3Set, (Set)actualSet).size()).isEqualTo(2);
        }
    }

    @Test
    public void testRowNumberPartitionedLimit() {
        for (boolean hashEnabled : Arrays.asList(true, false)) {
            DriverContext driverContext = this.getDriverContext();
            RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT, DoubleType.DOUBLE});
            List<Page> input = rowPagesBuilder.row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.19).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).row(2L, 0.9).build();
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.of(3), Optional.empty(), 10, this.hashStrategyCompiler);
            MaterializedResult expectedPartition1 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.3, 1L}).row(new Object[]{0.4, 1L}).row(new Object[]{0.5, 1L}).row(new Object[]{0.6, 1L}).build();
            MaterializedResult expectedPartition2 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.2, 2L}).row(new Object[]{0.7, 2L}).row(new Object[]{0.8, 2L}).row(new Object[]{0.9, 2L}).build();
            MaterializedResult expectedPartition3 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.1, 3L}).row(new Object[]{0.19, 3L}).build();
            List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
            Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
            Assertions.assertThat((int)rowNumberColumn.getPositionCount()).isEqualTo(8);
            for (int i = 0; i < rowNumberColumn.getPositionCount(); ++i) {
                Assertions.assertThat((BigintType.BIGINT.getLong(rowNumberColumn, i) <= 3L ? 1 : 0) != 0).isTrue();
            }
            pages = TestRowNumberOperator.stripRowNumberColumn(pages);
            MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
            ImmutableSet actualSet = ImmutableSet.copyOf((Collection)actual.getMaterializedRows());
            ImmutableSet expectedPartition1Set = ImmutableSet.copyOf((Collection)expectedPartition1.getMaterializedRows());
            ImmutableSet expectedPartition2Set = ImmutableSet.copyOf((Collection)expectedPartition2.getMaterializedRows());
            ImmutableSet expectedPartition3Set = ImmutableSet.copyOf((Collection)expectedPartition3.getMaterializedRows());
            Assertions.assertThat((int)Sets.intersection((Set)expectedPartition1Set, (Set)actualSet).size()).isEqualTo(3);
            Assertions.assertThat((int)Sets.intersection((Set)expectedPartition2Set, (Set)actualSet).size()).isEqualTo(3);
            Assertions.assertThat((int)Sets.intersection((Set)expectedPartition3Set, (Set)actualSet).size()).isEqualTo(2);
        }
    }

    @Test
    public void testRowNumberUnpartitionedLimit() {
        DriverContext driverContext = this.getDriverContext();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.19).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).row(2L, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Optional.of(3), Optional.empty(), 10, this.hashStrategyCompiler);
        MaterializedResult expectedRows = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{0.3, 1L}).row(new Object[]{0.2, 2L}).row(new Object[]{0.1, 3L}).row(new Object[]{0.19, 3L}).row(new Object[]{0.4, 1L}).row(new Object[]{0.5, 1L}).row(new Object[]{0.6, 1L}).row(new Object[]{0.7, 2L}).row(new Object[]{0.8, 2L}).row(new Object[]{0.9, 2L}).build();
        List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assertions.assertThat((int)rowNumberColumn.getPositionCount()).isEqualTo(3);
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        Assertions.assertThat((int)actual.getMaterializedRows().size()).isEqualTo(3);
        ImmutableSet actualSet = ImmutableSet.copyOf((Collection)actual.getMaterializedRows());
        ImmutableSet expectedRowsSet = ImmutableSet.copyOf((Collection)expectedRows.getMaterializedRows());
        Assertions.assertThat((int)Sets.intersection((Set)expectedRowsSet, (Set)actualSet).size()).isEqualTo(3);
    }

    private static Block getRowNumberColumn(List<Page> pages) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(pages.size() * 100);
        for (Page page : pages) {
            int rowNumberChannel = page.getChannelCount() - 1;
            for (int i = 0; i < page.getPositionCount(); ++i) {
                BigintType.BIGINT.writeLong(builder, BigintType.BIGINT.getLong(page.getBlock(rowNumberChannel), i));
            }
        }
        return builder.build();
    }

    private static List<Page> stripRowNumberColumn(List<Page> input) {
        return (List)input.stream().map(page -> {
            Block[] blocks = new Block[page.getChannelCount() - 1];
            for (int i = 0; i < page.getChannelCount() - 1; ++i) {
                blocks[i] = page.getBlock(i);
            }
            return new Page(page.getPositionCount(), blocks);
        }).collect(ImmutableList.toImmutableList());
    }
}

