/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.util.List;

public class TestLongDecimalMaxAggregation
extends AbstractTestAggregationFunction {
    public static final DecimalType LONG_DECIMAL = DecimalType.createDecimalType((int)30, (int)5);

    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = LONG_DECIMAL.createFixedSizeBlockBuilder(length);
        for (int i = start; i < start + length; ++i) {
            Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL, (BlockBuilder)blockBuilder, (BigDecimal)BigDecimal.valueOf(i));
        }
        return new Block[]{blockBuilder.build()};
    }

    protected SqlDecimal getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return SqlDecimal.of((long)(start + length - 1), (int)30, (int)5);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)LONG_DECIMAL);
    }
}

