/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxbyn;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.minmaxbyn.TypedKeyValueHeap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.junit.jupiter.api.Test;

public class TestTypedKeyValueHeap {
    private static final int INPUT_SIZE = 1000000;
    private static final int OUTPUT_SIZE = 1000;
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();

    @Test
    public void testAscending() {
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000).boxed().toList());
    }

    @Test
    public void testDescending() {
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x).boxed().toList());
    }

    @Test
    public void testShuffled() {
        List<Integer> list = IntStream.range(0, 1000000).boxed().collect(Collectors.toList());
        Collections.shuffle(list);
        TestTypedKeyValueHeap.test(list);
    }

    private static void test(List<Integer> testData) {
        TestTypedKeyValueHeap.test((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, testData.stream().map(Long::valueOf).map(value -> new Entry<Long, Long>((Long)value, (Long)value)).toList(), Comparator.naturalOrder(), 1000);
        TestTypedKeyValueHeap.test((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, testData.stream().map(Long::valueOf).map(value -> new Entry<Long, Slice>((Long)value, Slices.utf8Slice((String)value.toString()))).toList(), Comparator.naturalOrder(), 1000);
        TestTypedKeyValueHeap.test((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT, testData.stream().map(Long::valueOf).map(value -> new Entry<Slice, Long>(Slices.utf8Slice((String)value.toString()), (Long)value)).toList(), Comparator.naturalOrder(), 1000);
        TestTypedKeyValueHeap.test((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, testData.stream().map(String::valueOf).map(Slices::utf8Slice).map(value -> new Entry<Slice, Slice>((Slice)value, (Slice)value)).toList(), Comparator.naturalOrder(), 1000);
    }

    @Test
    public void testEmptyVariableWidth() {
        TestTypedKeyValueHeap.test((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, Collections.nCopies(1000000, new Entry<Slice, Slice>(Slices.EMPTY_SLICE, Slices.EMPTY_SLICE)), Comparator.naturalOrder(), 1000);
    }

    @Test
    public void testNulls() {
        TestTypedKeyValueHeap.test((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, LongStream.range(0L, 10L).boxed().map(value -> new Entry<Long, Long>((Long)value, value == 5L ? null : value)).toList(), Comparator.naturalOrder(), 1000);
    }

    @Test
    public void testX() {
        TestTypedKeyValueHeap.test((Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE, ImmutableList.builder().add(new Entry<Slice, Double>(Slices.utf8Slice((String)"z"), 1.0)).add(new Entry<Slice, Double>(Slices.utf8Slice((String)"a"), 2.0)).add(new Entry<Slice, Double>(Slices.utf8Slice((String)"x"), 2.0)).add(new Entry<Slice, Double>(Slices.utf8Slice((String)"b"), 3.0)).build(), Comparator.naturalOrder(), 2);
    }

    private static <K, V> void test(Type keyType, Type valueType, List<Entry<K, V>> testData, Comparator<K> comparator, int capacity) {
        TestTypedKeyValueHeap.test(keyType, valueType, true, testData, comparator, capacity);
        TestTypedKeyValueHeap.test(keyType, valueType, false, testData, comparator, capacity);
    }

    private static <K, V> void test(Type keyType, Type valueType, boolean min, List<Entry<K, V>> testData, Comparator<K> comparator, int capacity) {
        MethodHandle comparisonFlatBlock;
        MethodHandle comparisonFlatFlat;
        MethodHandle keyReadFlat = TYPE_OPERATORS.getReadValueOperator(keyType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
        MethodHandle keyWriteFlat = TYPE_OPERATORS.getReadValueOperator(keyType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}));
        MethodHandle valueReadFlat = TYPE_OPERATORS.getReadValueOperator(valueType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
        MethodHandle valueWriteFlat = TYPE_OPERATORS.getReadValueOperator(valueType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}));
        if (min) {
            comparisonFlatFlat = TYPE_OPERATORS.getComparisonUnorderedLastOperator(keyType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}));
            comparisonFlatBlock = TYPE_OPERATORS.getComparisonUnorderedLastOperator(keyType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}));
        } else {
            comparisonFlatFlat = TYPE_OPERATORS.getComparisonUnorderedFirstOperator(keyType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}));
            comparisonFlatBlock = TYPE_OPERATORS.getComparisonUnorderedFirstOperator(keyType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}));
            comparator = comparator.reversed();
        }
        ValueBlock expected = TestTypedKeyValueHeap.toBlock(valueType, testData.stream().sorted(Comparator.comparing(Entry::key, comparator)).map(Entry::value).limit(capacity).toList());
        ValueBlock inputKeys = TestTypedKeyValueHeap.toBlock(keyType, testData.stream().map(Entry::key).toList());
        ValueBlock inputValues = TestTypedKeyValueHeap.toBlock(valueType, testData.stream().map(Entry::value).toList());
        TypedKeyValueHeap heap = new TypedKeyValueHeap(min, keyReadFlat, keyWriteFlat, valueReadFlat, valueWriteFlat, comparisonFlatFlat, comparisonFlatBlock, keyType, valueType, capacity);
        TestTypedKeyValueHeap.getAddAll(heap, inputKeys, inputValues);
        TestTypedKeyValueHeap.assertEqual(heap, valueType, expected);
        TestTypedKeyValueHeap.assertEqual(new TypedKeyValueHeap(heap), valueType, expected);
        TypedKeyValueHeap part1 = new TypedKeyValueHeap(min, keyReadFlat, keyWriteFlat, valueReadFlat, valueWriteFlat, comparisonFlatFlat, comparisonFlatBlock, keyType, valueType, capacity);
        int splitPoint = inputKeys.getPositionCount() / 2;
        TestTypedKeyValueHeap.getAddAll(part1, inputKeys.getRegion(0, splitPoint), inputValues.getRegion(0, splitPoint));
        BlockBuilder part1KeyBlockBuilder = keyType.createBlockBuilder(null, part1.getCapacity());
        BlockBuilder part1ValueBlockBuilder = valueType.createBlockBuilder(null, part1.getCapacity());
        part1.writeAllUnsorted(part1KeyBlockBuilder, part1ValueBlockBuilder);
        ValueBlock part1KeyBlock = part1KeyBlockBuilder.buildValueBlock();
        ValueBlock part1ValueBlock = part1ValueBlockBuilder.buildValueBlock();
        TypedKeyValueHeap part2 = new TypedKeyValueHeap(min, keyReadFlat, keyWriteFlat, valueReadFlat, valueWriteFlat, comparisonFlatFlat, comparisonFlatBlock, keyType, valueType, capacity);
        TestTypedKeyValueHeap.getAddAll(part2, inputKeys.getRegion(splitPoint, inputKeys.getPositionCount() - splitPoint), inputValues.getRegion(splitPoint, inputValues.getPositionCount() - splitPoint));
        BlockBuilder part2KeyBlockBuilder = keyType.createBlockBuilder(null, part2.getCapacity());
        BlockBuilder part2ValueBlockBuilder = valueType.createBlockBuilder(null, part2.getCapacity());
        part2.writeAllUnsorted(part2KeyBlockBuilder, part2ValueBlockBuilder);
        ValueBlock part2KeyBlock = part2KeyBlockBuilder.buildValueBlock();
        ValueBlock part2ValueBlock = part2ValueBlockBuilder.buildValueBlock();
        TypedKeyValueHeap merged = new TypedKeyValueHeap(min, keyReadFlat, keyWriteFlat, valueReadFlat, valueWriteFlat, comparisonFlatFlat, comparisonFlatBlock, keyType, valueType, capacity);
        TestTypedKeyValueHeap.getAddAll(merged, part1KeyBlock, part1ValueBlock);
        TestTypedKeyValueHeap.getAddAll(merged, part2KeyBlock, part2ValueBlock);
        TestTypedKeyValueHeap.assertEqual(merged, valueType, expected);
    }

    private static void getAddAll(TypedKeyValueHeap heap, ValueBlock inputKeys, ValueBlock inputValues) {
        for (int i = 0; i < inputKeys.getPositionCount(); ++i) {
            heap.add(inputKeys, i, inputValues, i);
        }
    }

    private static void assertEqual(TypedKeyValueHeap heap, Type valueType, ValueBlock expected) {
        BlockBuilder resultBlockBuilder = valueType.createBlockBuilder(null, 1000);
        heap.writeValuesSorted(resultBlockBuilder);
        ValueBlock actual = resultBlockBuilder.buildValueBlock();
        BlockAssertions.assertBlockEquals(valueType, (Block)actual, (Block)expected);
    }

    private static <T> ValueBlock toBlock(Type type, List<T> inputStream) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1000000);
        inputStream.forEach(value -> TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)value));
        return blockBuilder.buildValueBlock();
    }

    private record Entry<K, V>(K key, V value) {
    }
}

