/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.type.UnknownType;
import io.trino.util.StructuralTestUtil;
import java.util.HashMap;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestMapTransformValuesFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testEmpty() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> NULL)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> v)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> 0)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> true)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> 'value')").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)VarcharType.createVarcharType((int)5))).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k + CAST(v as BIGINT))").binding("a", "CAST (map(ARRAY[], ARRAY[]) AS MAP(BIGINT,VARCHAR))")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> CAST(k AS VARCHAR) || v)").binding("a", "CAST (map(ARRAY[], ARRAY[]) AS MAP(BIGINT,VARCHAR))")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of());
    }

    @Test
    public void testNullValue() {
        HashMap<Integer, Object> sequenceToNullMap = new HashMap<Integer, Object>();
        sequenceToNullMap.put(1, null);
        sequenceToNullMap.put(2, null);
        sequenceToNullMap.put(3, null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> NULL)").binding("a", "map(ARRAY[1, 2, 3], ARRAY['a', 'b', 'c'])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN)).isEqualTo(sequenceToNullMap);
        HashMap<Integer, String> mapWithNullValue = new HashMap<Integer, String>();
        mapWithNullValue.put(1, "a");
        mapWithNullValue.put(2, "b");
        mapWithNullValue.put(3, null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> v)").binding("a", "map(ARRAY[1, 2, 3], ARRAY['a', 'b', NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1))).isEqualTo(mapWithNullValue);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> to_base(v, 16))").binding("a", "map(ARRAY[1, 2, 3], ARRAY[10, 11, NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)64))).isEqualTo(mapWithNullValue);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> to_base(TRY_CAST(v as BIGINT), 16))").binding("a", "map(ARRAY[1, 2, 3], ARRAY['10', '11', 'Invalid'])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)64))).isEqualTo(mapWithNullValue);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> element_at(map(ARRAY[1, 2], ARRAY['a', 'b']), k + v))").binding("a", "map(ARRAY[1, 2, 3], ARRAY[0, 0, 0])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1))).isEqualTo(mapWithNullValue);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> IF(v IS NULL, k + 1.0E0, k + 0.5E0))").binding("a", "map(ARRAY[1, 2, 3], ARRAY['a', 'b', NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)1, (Object)1.5, (Object)2, (Object)2.5, (Object)3, (Object)4.0));
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k + v)").binding("a", "map(ARRAY[1, 2, 3, 4], ARRAY[10, 20, 30, 40])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)1, (Object)11, (Object)2, (Object)22, (Object)3, (Object)33, (Object)4, (Object)44));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> v * v)").binding("a", "map(ARRAY['a', 'b', 'c', 'd'], ARRAY[1, 2, 3, 4])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)4, (Object)"c", (Object)9, (Object)"d", (Object)16));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k || CAST(v as VARCHAR))").binding("a", "map(ARRAY['a', 'b', 'c', 'd'], ARRAY[1, 2, 3, 4])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"a", (Object)"a1", (Object)"b", (Object)"b2", (Object)"c", (Object)"c3", (Object)"d", (Object)"d4"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> map(ARRAY[1, 2, 3], ARRAY['one', 'two', 'three'])[k] || '_' || CAST(v AS VARCHAR))").binding("a", "map(ARRAY[1, 2, 3], ARRAY[1.0E0, 1.4E0, 1.7E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)1, (Object)"one_1.0E0", (Object)2, (Object)"two_1.4E0", (Object)3, (Object)"three_1.7E0"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> date_add('year', 1, v))").binding("a", "map(ARRAY[1, 2], ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '2010-05-10 12:34:56.123456789'])")))).matches("map_from_entries(ARRAY[(1, TIMESTAMP '2021-05-10 12:34:56.123456789'), (2, TIMESTAMP '2011-05-10 12:34:56.123456789')])");
    }

    @Test
    public void testTypeCombinations() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k + v)").binding("a", "map(ARRAY[25, 26, 27], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)25, (Object)50, (Object)26, (Object)52, (Object)27, (Object)54));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> CAST(v - k AS BIGINT))").binding("a", "map(ARRAY[25, 26, 27], ARRAY[26.1E0, 31.2E0, 37.1E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)25, (Object)1L, (Object)26, (Object)5L, (Object)27, (Object)10L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> if(v, k + 1, k + 2))").binding("a", "map(ARRAY[25, 27], ARRAY[false, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)25, (Object)27, (Object)27, (Object)28));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k + length(v))").binding("a", "map(ARRAY[25, 26, 27], ARRAY['abc', 'd', 'xy'])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)25, (Object)28L, (Object)26, (Object)27L, (Object)27, (Object)29L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k + cardinality(v))").binding("a", "map(ARRAY[25, 26, 27], ARRAY[ARRAY['a'], ARRAY['a', 'c'], ARRAY['a', 'b', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)25, (Object)26L, (Object)26, (Object)28L, (Object)27, (Object)30L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k - v)").binding("a", "map(ARRAY[25.5E0, 26.75E0, 27.875E0], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)25.5, (Object)0.5, (Object)26.75, (Object)0.75, (Object)27.875, (Object)0.875));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k - v)").binding("a", "map(ARRAY[25.5E0, 26.75E0, 27.875E0], ARRAY[25.0E0, 26.0E0, 27.0E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)25.5, (Object)0.5, (Object)26.75, (Object)0.75, (Object)27.875, (Object)0.875));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> if(v, k + 0.1E0, k + 0.2E0))").binding("a", "map(ARRAY[25.5E0, 27.5E0], ARRAY[false, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)25.5, (Object)25.7, (Object)27.5, (Object)27.6));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k + length(v))").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY['a', 'def', 'xy'])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)25.5, (Object)26.5, (Object)26.5, (Object)29.5, (Object)27.5, (Object)29.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k + cardinality(v))").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY[ARRAY['a'], ARRAY['a', 'c'], ARRAY['a', 'b', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)25.5, (Object)26.5, (Object)26.5, (Object)28.5, (Object)27.5, (Object)30.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k AND v = 25)").binding("a", "map(ARRAY[true, false], ARRAY[25, 26])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)true, (Object)true, (Object)false, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k OR v > 100)").binding("a", "map(ARRAY[false, true], ARRAY[25.5E0, 26.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> NOT k OR v)").binding("a", "map(ARRAY[true, false], ARRAY[false, null])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)false, (Object)true, (Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> NOT k AND v = 'abc')").binding("a", "map(ARRAY[false, true], ARRAY['abc', 'def'])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)false, (Object)true, (Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k OR cardinality(v) = 3)").binding("a", "map(ARRAY[true, false], ARRAY[ARRAY['a', 'b'], ARRAY['a', 'b', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)false, (Object)true, (Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k || ':' || CAST(v as VARCHAR))").binding("a", "map(ARRAY['s0', 's1', 's2'], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"s0", (Object)"s0:25", (Object)"s1", (Object)"s1:26", (Object)"s2", (Object)"s2:27"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k || ':' || CAST(v as VARCHAR))").binding("a", "map(ARRAY['s0', 's1', 's2'], ARRAY[25.5E0, 26.5E0, 27.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"s0", (Object)"s0:2.55E1", (Object)"s1", (Object)"s1:2.65E1", (Object)"s2", (Object)"s2:2.75E1"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> if(v, k, CAST(v AS VARCHAR)))").binding("a", "map(ARRAY['s0', 's2'], ARRAY[false, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"s0", (Object)"false", (Object)"s2", (Object)"s2"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k || ':' || v)").binding("a", "map(ARRAY['s0', 's1', 's2'], ARRAY['abc', 'def', 'xyz'])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"s0", (Object)"s0:abc", (Object)"s1", (Object)"s1:def", (Object)"s2", (Object)"s2:xyz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k || ':' || array_max(v))").binding("a", "map(ARRAY['s0', 's1', 's2'], ARRAY[ARRAY['a', 'b'], ARRAY['a', 'c'], ARRAY['a', 'b', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"s0", (Object)"s0:b", (Object)"s1", (Object)"s1:c", (Object)"s2", (Object)"s2:c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> if(v % 2 = 0, reverse(k), k))").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4]], ARRAY[25, 26])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)4, (Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> CAST(k AS ARRAY(DOUBLE)) || v)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4]], ARRAY[25.5E0, 26.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)DoubleType.DOUBLE))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1.0, (Object)2.0, (Object)25.5), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)3.0, (Object)4.0, (Object)26.5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> if(v, reverse(k), k))").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4]], ARRAY[false, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)4, (Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> k || from_base(v, 16))").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[]], ARRAY['a', 'ff'])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BigintType.BIGINT))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)255L)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform_values(a, (k, v) -> transform(k, x -> CAST(x AS VARCHAR)) || v)").binding("a", "map(ARRAY[ARRAY[3, 4], ARRAY[]], ARRAY[ARRAY['a', 'b', 'c'], ARRAY['a', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"a", (Object)"c")));
    }
}

