/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import com.google.common.collect.ImmutableList;
import io.trino.execution.buffer.BenchmarkDataGenerator;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.scalar.timestamp.TimestampToTimestampCast;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneToTimestampWithTimeZoneCast;
import io.trino.operator.scalar.timetz.TimeWithTimeZoneToTimeWithTimeZoneCast;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.testing.TestingConnectorSession;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.Throughput})
@Fork(value=1)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
public class BenchmarkCastTimestampToVarchar {
    private static final int POSITIONS_PER_PAGE = 1024;

    @Benchmark
    public List<Optional<Page>> benchmarkCastToVarchar(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.pageProcessor.process(TestingConnectorSession.SESSION, data.yieldSignal, data.localMemoryContext, data.page));
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"TIME", "TIME_WITH_TIME_ZONE", "TIMESTAMP", "TIMESTAMP_WITH_TIME_ZONE"})
        private String type;
        @Param(value={"0", "3", "12"})
        private int precision;
        private Random random;
        private DriverYieldSignal yieldSignal;
        private LocalMemoryContext localMemoryContext;
        private PageProcessor pageProcessor;
        private Page page;

        @Setup
        public void setup() {
            TimeType sourceType;
            this.random = new Random(0L);
            this.yieldSignal = new DriverYieldSignal();
            this.localMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
            switch (this.type) {
                case "TIME": {
                    TimeType timeType;
                    sourceType = timeType = TimeType.createTimeType((int)this.precision);
                    this.page = BenchmarkData.createTimePage(this.random, timeType);
                    break;
                }
                case "TIME_WITH_TIME_ZONE": {
                    TimeWithTimeZoneType timeTzType = TimeWithTimeZoneType.createTimeWithTimeZoneType((int)this.precision);
                    sourceType = timeTzType;
                    this.page = BenchmarkData.createTimeTzPage(this.random, timeTzType);
                    break;
                }
                case "TIMESTAMP": {
                    TimestampType timestampType = TimestampType.createTimestampType((int)this.precision);
                    sourceType = timestampType;
                    this.page = BenchmarkData.createTimestampPage(this.random, timestampType);
                    break;
                }
                case "TIMESTAMP_WITH_TIME_ZONE": {
                    TimestampWithTimeZoneType timestampTzType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)this.precision);
                    sourceType = timestampTzType;
                    this.page = BenchmarkData.createTimestampTzPage(this.random, timestampTzType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + this.type);
                }
            }
            TestingFunctionResolution functionResolution = new TestingFunctionResolution();
            ImmutableList timestampProjections = ImmutableList.of((Object)new CallExpression(functionResolution.getCoercion((Type)sourceType, (Type)VarcharType.createUnboundedVarcharType()), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)sourceType))));
            this.pageProcessor = (PageProcessor)functionResolution.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)timestampProjections).get();
        }

        private static Page createTimePage(Random random, TimeType timeType) {
            BlockBuilder builder = timeType.createFixedSizeBlockBuilder(1024);
            for (int i = 0; i < 1024; ++i) {
                timeType.writeLong(builder, SqlTime.newInstance((int)12, (long)random.nextLong(86400000000000000L)).roundTo(timeType.getPrecision()).getPicos());
            }
            return new Page(new Block[]{builder.build()});
        }

        private static Page createTimeTzPage(Random random, TimeWithTimeZoneType timeTzType) {
            BlockBuilder builder = timeTzType.createFixedSizeBlockBuilder(1024);
            for (int i = 0; i < 1024; ++i) {
                LongTimeWithTimeZone value = new LongTimeWithTimeZone(random.nextLong(86400000000000000L), 0);
                if (timeTzType.isShort()) {
                    timeTzType.writeLong(builder, TimeWithTimeZoneToTimeWithTimeZoneCast.longToShort((long)timeTzType.getPrecision(), (LongTimeWithTimeZone)value));
                    continue;
                }
                timeTzType.writeObject(builder, (Object)TimeWithTimeZoneToTimeWithTimeZoneCast.longToLong((long)timeTzType.getPrecision(), (LongTimeWithTimeZone)value));
            }
            return new Page(new Block[]{builder.build()});
        }

        private static Page createTimestampPage(Random random, TimestampType timestampType) {
            BlockBuilder builder = timestampType.createFixedSizeBlockBuilder(1024);
            for (int i = 0; i < 1024; ++i) {
                LongTimestamp value = BenchmarkDataGenerator.randomTimestamp(random);
                if (timestampType.isShort()) {
                    timestampType.writeLong(builder, TimestampToTimestampCast.longToShort((long)timestampType.getPrecision(), (LongTimestamp)value));
                    continue;
                }
                timestampType.writeObject(builder, (Object)TimestampToTimestampCast.longToLong((long)timestampType.getPrecision(), (LongTimestamp)value));
            }
            return new Page(new Block[]{builder.build()});
        }

        private static Page createTimestampTzPage(Random random, TimestampWithTimeZoneType timestampTzType) {
            BlockBuilder builder = timestampTzType.createFixedSizeBlockBuilder(1024);
            for (int i = 0; i < 1024; ++i) {
                long epochMillis = random.nextLong(2048L);
                int picosFraction = random.nextInt(1000000000);
                LongTimestampWithTimeZone value = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picosFraction, (TimeZoneKey)TimeZoneKey.UTC_KEY);
                if (timestampTzType.isShort()) {
                    timestampTzType.writeLong(builder, TimestampWithTimeZoneToTimestampWithTimeZoneCast.longToShort((long)timestampTzType.getPrecision(), (LongTimestampWithTimeZone)value));
                    continue;
                }
                timestampTzType.writeObject(builder, (Object)TimestampWithTimeZoneToTimestampWithTimeZoneCast.longToLong((long)timestampTzType.getPrecision(), (LongTimestampWithTimeZone)value));
            }
            return new Page(new Block[]{builder.build()});
        }
    }
}

