/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.window.AbstractTestWindowFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedResult;
import org.junit.jupiter.api.Test;

public class TestLastValueFunction
extends AbstractTestWindowFunction {
    @Test
    public void testLastValueUnbounded() {
        this.assertUnboundedWindowQuery("last_value(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1993-10-27"}).row(new Object[]{5, "F", "1993-10-27"}).row(new Object[]{6, "F", "1993-10-27"}).row(new Object[]{33, "F", "1993-10-27"}).row(new Object[]{1, "O", "1998-07-21"}).row(new Object[]{2, "O", "1998-07-21"}).row(new Object[]{4, "O", "1998-07-21"}).row(new Object[]{7, "O", "1998-07-21"}).row(new Object[]{32, "O", "1998-07-21"}).row(new Object[]{34, "O", "1998-07-21"}).build());
        this.assertUnboundedWindowQueryWithNulls("last_value(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3L, "F", "1993-10-27"}).row(new Object[]{5L, "F", "1993-10-27"}).row(new Object[]{6L, "F", "1993-10-27"}).row(new Object[]{null, "F", "1993-10-27"}).row(new Object[]{34L, "O", "1996-12-01"}).row(new Object[]{null, "O", "1996-12-01"}).row(new Object[]{1L, null, "1995-07-16"}).row(new Object[]{7L, null, "1995-07-16"}).row(new Object[]{null, null, "1995-07-16"}).row(new Object[]{null, null, "1995-07-16"}).build());
        this.assertUnboundedWindowQuery("last_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, IntegerType.INTEGER}).row(new Object[]{3, "F", 33}).row(new Object[]{5, "F", 33}).row(new Object[]{6, "F", 33}).row(new Object[]{33, "F", 33}).row(new Object[]{1, "O", 34}).row(new Object[]{2, "O", 34}).row(new Object[]{4, "O", 34}).row(new Object[]{7, "O", 34}).row(new Object[]{32, "O", 34}).row(new Object[]{34, "O", 34}).build());
        this.assertUnboundedWindowQueryWithNulls("last_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", null}).row(new Object[]{5L, "F", null}).row(new Object[]{6L, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
        this.assertWindowQuery("date_format(last_value(cast(orderdate as TIMESTAMP)) OVER (PARTITION BY orderstatus ORDER BY orderkey), '%Y-%m-%d')", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1993-10-14"}).row(new Object[]{5, "F", "1994-07-30"}).row(new Object[]{6, "F", "1992-02-21"}).row(new Object[]{33, "F", "1993-10-27"}).row(new Object[]{1, "O", "1996-01-02"}).row(new Object[]{2, "O", "1996-12-01"}).row(new Object[]{4, "O", "1995-10-11"}).row(new Object[]{7, "O", "1996-01-10"}).row(new Object[]{32, "O", "1995-07-16"}).row(new Object[]{34, "O", "1998-07-21"}).build());
    }

    @Test
    public void testLastValueUnboundedIgnoreNulls() {
        this.assertUnboundedWindowQueryWithNulls("last_value(orderkey) IGNORE NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 6L}).row(new Object[]{5L, "F", 6L}).row(new Object[]{6L, "F", 6L}).row(new Object[]{null, "F", 6L}).row(new Object[]{34L, "O", 34L}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, 7L}).row(new Object[]{7L, null, 7L}).row(new Object[]{null, null, 7L}).row(new Object[]{null, null, 7L}).build());
    }

    @Test
    public void testLastValueUnboundedRespectNulls() {
        this.assertUnboundedWindowQueryWithNulls("last_value(orderkey) RESPECT NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", null}).row(new Object[]{5L, "F", null}).row(new Object[]{6L, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
    }

    @Test
    public void testLastValueBounded() {
        this.assertWindowQuery("last_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, IntegerType.INTEGER}).row(new Object[]{3, "F", 6}).row(new Object[]{5, "F", 33}).row(new Object[]{6, "F", 33}).row(new Object[]{33, "F", 33}).row(new Object[]{1, "O", 4}).row(new Object[]{2, "O", 7}).row(new Object[]{4, "O", 32}).row(new Object[]{7, "O", 34}).row(new Object[]{32, "O", 34}).row(new Object[]{34, "O", 34}).build());
        this.assertWindowQueryWithNulls("last_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 6L}).row(new Object[]{5L, "F", null}).row(new Object[]{6L, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
    }

    @Test
    public void testLastValueBoundedIgnoreNulls() {
        this.assertWindowQueryWithNulls("last_value(orderkey) IGNORE NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 6L}).row(new Object[]{5L, "F", 6L}).row(new Object[]{6L, "F", 6L}).row(new Object[]{null, "F", 6L}).row(new Object[]{34L, "O", 34L}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, 7L}).row(new Object[]{7L, null, 7L}).row(new Object[]{null, null, 7L}).row(new Object[]{null, null, 7L}).build());
        this.assertWindowQueryWithNulls("last_value(orderkey) IGNORE NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 5L}).row(new Object[]{5L, "F", 6L}).row(new Object[]{6L, "F", 6L}).row(new Object[]{null, "F", 6L}).row(new Object[]{34L, "O", 34L}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, 7L}).row(new Object[]{7L, null, 7L}).row(new Object[]{null, null, 7L}).row(new Object[]{null, null, null}).build());
    }

    @Test
    public void testLastValueBoundedRespectNulls() {
        this.assertWindowQueryWithNulls("last_value(orderkey) RESPECT NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 6L}).row(new Object[]{5L, "F", null}).row(new Object[]{6L, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
        this.assertWindowQueryWithNulls("last_value(orderkey) RESPECT NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 5L}).row(new Object[]{5L, "F", 6L}).row(new Object[]{6L, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, 7L}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
    }
}

