/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.server.protocol.spooling.SpoolingConfig;
import io.trino.util.Ciphers;
import java.util.Base64;
import java.util.Map;
import org.junit.jupiter.api.Test;

class TestSpoolingConfig {
    TestSpoolingConfig() {
    }

    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((SpoolingConfig)ConfigAssertions.recordDefaults(SpoolingConfig.class)).setUseWorkers(false).setDirectStorageAccess(true).setDirectStorageFallback(false).setInlineSegments(true).setSharedEncryptionKey(null).setInitialSegmentSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaximumSegmentSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        String randomAesEncryptionKey = Base64.getEncoder().encodeToString(Ciphers.createRandomAesEncryptionKey().getEncoded());
        ImmutableMap properties = ImmutableMap.builder().put((Object)"protocol.spooling.worker-access", (Object)"true").put((Object)"protocol.spooling.direct-storage-access", (Object)"false").put((Object)"protocol.spooling.direct-storage-fallback", (Object)"true").put((Object)"protocol.spooling.inline-segments", (Object)"false").put((Object)"protocol.spooling.shared-secret-key", (Object)randomAesEncryptionKey).put((Object)"protocol.spooling.initial-segment-size", (Object)"2MB").put((Object)"protocol.spooling.maximum-segment-size", (Object)"4MB").buildOrThrow();
        SpoolingConfig expected = new SpoolingConfig().setUseWorkers(true).setDirectStorageAccess(false).setDirectStorageFallback(true).setInlineSegments(false).setSharedEncryptionKey(randomAesEncryptionKey).setInitialSegmentSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaximumSegmentSize(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

