/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.RelationId;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.QualifiedName;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestScope {
    @Test
    public void test() {
        Scope root = Scope.create();
        Field outerColumn1 = Field.newQualified((QualifiedName)QualifiedName.of((String)"outer", (String[])new String[]{"column1"}), Optional.of("c1"), (Type)BigintType.BIGINT, (boolean)false, Optional.empty(), Optional.empty(), (boolean)false);
        Field outerColumn2 = Field.newQualified((QualifiedName)QualifiedName.of((String)"outer", (String[])new String[]{"column2"}), Optional.of("c2"), (Type)BigintType.BIGINT, (boolean)false, Optional.empty(), Optional.empty(), (boolean)false);
        Scope outer = Scope.builder().withParent(root).withRelationType(RelationId.anonymous(), new RelationType(new Field[]{outerColumn1, outerColumn2})).build();
        Field innerColumn2 = Field.newQualified((QualifiedName)QualifiedName.of((String)"inner", (String[])new String[]{"column2"}), Optional.of("c2"), (Type)BigintType.BIGINT, (boolean)false, Optional.empty(), Optional.empty(), (boolean)false);
        Field innerColumn3 = Field.newQualified((QualifiedName)QualifiedName.of((String)"inner", (String[])new String[]{"column3"}), Optional.of("c3"), (Type)BigintType.BIGINT, (boolean)false, Optional.empty(), Optional.empty(), (boolean)false);
        Scope inner = Scope.builder().withOuterQueryParent(outer).withRelationType(RelationId.anonymous(), new RelationType(new Field[]{innerColumn2, innerColumn3})).build();
        Expression c1 = TestScope.name("c1", new String[0]);
        Expression c2 = TestScope.name("c2", new String[0]);
        Expression c3 = TestScope.name("c3", new String[0]);
        Expression c4 = TestScope.name("c4", new String[0]);
        Assertions.assertThat((Optional)root.tryResolveField(c1)).isEmpty();
        Assertions.assertThat((Optional)outer.tryResolveField(c1)).isPresent();
        Assertions.assertThat((Object)((ResolvedField)outer.tryResolveField(c1).get()).getField()).isEqualTo((Object)outerColumn1);
        Assertions.assertThat((boolean)((ResolvedField)outer.tryResolveField(c1).get()).isLocal()).isEqualTo(true);
        Assertions.assertThat((int)((ResolvedField)outer.tryResolveField(c1).get()).getHierarchyFieldIndex()).isEqualTo(0);
        Assertions.assertThat((Optional)outer.tryResolveField(c2)).isPresent();
        Assertions.assertThat((Object)((ResolvedField)outer.tryResolveField(c2).get()).getField()).isEqualTo((Object)outerColumn2);
        Assertions.assertThat((boolean)((ResolvedField)outer.tryResolveField(c2).get()).isLocal()).isEqualTo(true);
        Assertions.assertThat((int)((ResolvedField)outer.tryResolveField(c2).get()).getHierarchyFieldIndex()).isEqualTo(1);
        Assertions.assertThat((Optional)outer.tryResolveField(c3)).isEmpty();
        Assertions.assertThat((Optional)outer.tryResolveField(c4)).isEmpty();
        Assertions.assertThat((Optional)inner.tryResolveField(c1)).isPresent();
        Assertions.assertThat((Object)((ResolvedField)inner.tryResolveField(c1).get()).getField()).isEqualTo((Object)outerColumn1);
        Assertions.assertThat((boolean)((ResolvedField)inner.tryResolveField(c1).get()).isLocal()).isEqualTo(false);
        Assertions.assertThat((int)((ResolvedField)inner.tryResolveField(c1).get()).getHierarchyFieldIndex()).isEqualTo(0);
        Assertions.assertThat((int)((ResolvedField)inner.tryResolveField(c1).get()).getRelationFieldIndex()).isEqualTo(0);
        Assertions.assertThat((Optional)inner.tryResolveField(c2)).isPresent();
        Assertions.assertThat((Object)((ResolvedField)inner.tryResolveField(c2).get()).getField()).isEqualTo((Object)innerColumn2);
        Assertions.assertThat((boolean)((ResolvedField)inner.tryResolveField(c2).get()).isLocal()).isEqualTo(true);
        Assertions.assertThat((int)((ResolvedField)inner.tryResolveField(c2).get()).getHierarchyFieldIndex()).isEqualTo(0);
        Assertions.assertThat((Optional)inner.tryResolveField(c2)).isPresent();
        Assertions.assertThat((Object)((ResolvedField)inner.tryResolveField(c3).get()).getField()).isEqualTo((Object)innerColumn3);
        Assertions.assertThat((boolean)((ResolvedField)inner.tryResolveField(c3).get()).isLocal()).isEqualTo(true);
        Assertions.assertThat((int)((ResolvedField)inner.tryResolveField(c3).get()).getHierarchyFieldIndex()).isEqualTo(1);
        Assertions.assertThat((Optional)inner.tryResolveField(c4)).isEmpty();
        Assertions.assertThat((Optional)inner.getOuterQueryParent()).isEqualTo(Optional.of(outer));
    }

    private static Expression name(String first, String ... parts) {
        return DereferenceExpression.from((QualifiedName)QualifiedName.of((String)first, (String[])parts));
    }
}

