/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemColumn;
import io.trino.tpch.LineItemGenerator;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=2)
@Warmup(iterations=15, time=1)
@Measurement(iterations=10, time=1)
public class BenchmarkAndColumnarFilterTpchData {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();
    private static final int EXTENDED_PRICE = 0;
    private static final int DISCOUNT = 1;
    private static final int SHIP_DATE = 2;
    private static final int QUANTITY = 3;
    private static final Slice MIN_SHIP_DATE = Slices.utf8Slice((String)"1994-01-01");
    private static final Slice MAX_SHIP_DATE = Slices.utf8Slice((String)"1995-01-01");
    private Page inputPage;
    private PageProcessor processor;
    @Param(value={"true", "false"})
    public boolean columnarEvaluationEnabled;

    @Setup
    public void setup() {
        this.inputPage = BenchmarkAndColumnarFilterTpchData.createInputPage();
        RowExpression filterExpression = BenchmarkAndColumnarFilterTpchData.createFilterExpression(FUNCTION_RESOLUTION);
        ExpressionCompiler expressionCompiler = FUNCTION_RESOLUTION.getExpressionCompiler();
        ImmutableList projections = ImmutableList.of((Object)new InputReferenceExpression(0, (Type)DoubleType.DOUBLE));
        this.processor = (PageProcessor)expressionCompiler.compilePageProcessor(this.columnarEvaluationEnabled, Optional.of(filterExpression), Optional.empty(), (List)projections, Optional.empty(), OptionalInt.empty()).apply(DynamicFilter.EMPTY);
    }

    @Benchmark
    public List<Optional<Page>> compiled() {
        return ImmutableList.copyOf((Iterator)this.processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), this.inputPage));
    }

    private static Page createInputPage() {
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE));
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        for (int i = 0; i < 10000; ++i) {
            pageBuilder.declarePosition();
            LineItem lineItem = (LineItem)iterator.next();
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), lineItem.extendedPrice());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.discount());
            VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(2), Slices.wrappedBuffer((byte[])LineItemColumn.SHIP_DATE.getString(lineItem).getBytes(StandardCharsets.UTF_8)));
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(3), (double)lineItem.quantity());
        }
        return pageBuilder.build();
    }

    private static RowExpression createFilterExpression(TestingFunctionResolution functionResolution) {
        return new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)new CallExpression(functionResolution.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)), (List)ImmutableList.of((Object)Expressions.constant((Object)MIN_SHIP_DATE, (Type)VarcharType.VARCHAR), (Object)Expressions.field((int)2, (Type)VarcharType.VARCHAR))), (Object)new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)new CallExpression(functionResolution.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR)), (List)ImmutableList.of((Object)Expressions.field((int)2, (Type)VarcharType.VARCHAR), (Object)Expressions.constant((Object)MAX_SHIP_DATE, (Type)VarcharType.VARCHAR))), (Object)new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)new CallExpression(functionResolution.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (List)ImmutableList.of((Object)Expressions.constant((Object)0.05, (Type)DoubleType.DOUBLE), (Object)Expressions.field((int)1, (Type)DoubleType.DOUBLE))), (Object)new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)new CallExpression(functionResolution.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (List)ImmutableList.of((Object)Expressions.field((int)1, (Type)DoubleType.DOUBLE), (Object)Expressions.constant((Object)0.07, (Type)DoubleType.DOUBLE))), (Object)new CallExpression(functionResolution.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (List)ImmutableList.of((Object)Expressions.field((int)3, (Type)DoubleType.DOUBLE), (Object)Expressions.constant((Object)24.0, (Type)DoubleType.DOUBLE)))), (List)ImmutableList.of())), (List)ImmutableList.of())), (List)ImmutableList.of())), (List)ImmutableList.of());
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkAndColumnarFilterTpchData.class).run();
    }
}

