/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.FlattenLogical;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestFlattenLogical {
    TestFlattenLogical() {
    }

    @Test
    void testOr() {
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "c"), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "d"), (Object)new Reference((Type)BooleanType.BOOLEAN, "e"))))))).isEqualTo(Optional.of(new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"), (Object)new Reference((Type)BooleanType.BOOLEAN, "c"), (Object)new Reference((Type)BooleanType.BOOLEAN, "d"), (Object)new Reference((Type)BooleanType.BOOLEAN, "e")))));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)))).isEmpty();
    }

    @Test
    void testAnd() {
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "c"), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "d"), (Object)new Reference((Type)BooleanType.BOOLEAN, "e"))))))).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Reference((Type)BooleanType.BOOLEAN, "b"), (Object)new Reference((Type)BooleanType.BOOLEAN, "c"), (Object)new Reference((Type)BooleanType.BOOLEAN, "d"), (Object)new Reference((Type)BooleanType.BOOLEAN, "e")))));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)))).isEmpty();
    }

    @Test
    void testMixed() {
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)))))).isEqualTo(Optional.of(new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)), (Object)Booleans.TRUE, (Object)Booleans.FALSE))));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)))))).isEqualTo(Optional.of(new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)), (Object)Booleans.TRUE, (Object)Booleans.FALSE))));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new FlattenLogical().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

