/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.SimplifyStackedNot;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimplifyStackedNot {
    @Test
    void test() {
        Assertions.assertThat(this.optimize(IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))))).isEqualTo(Optional.of(new Reference((Type)BooleanType.BOOLEAN, "a")));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new SimplifyStackedNot().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

