/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.Signature;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.EffectivePredicateExtractor;
import io.trino.sql.planner.EqualityInference;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTransactionHandle;
import io.trino.testing.TransactionBuilder;
import io.trino.tests.BogusType;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.UnknownType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestEffectivePredicateExtractor {
    private static final Session SESSION = TestingSession.testSessionBuilder().build();
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private final Metadata metadata = new AbstractMockMetadata(){
        private final Metadata delegate;
        {
            this.delegate = TestEffectivePredicateExtractor.this.functionResolution.getMetadata();
        }

        @Override
        public ResolvedFunction resolveBuiltinFunction(String name, List<TypeSignatureProvider> parameterTypes) {
            return this.delegate.resolveBuiltinFunction(name, parameterTypes);
        }

        public ResolvedFunction getCoercion(Type fromType, Type toType) {
            return this.delegate.getCoercion(fromType, toType);
        }

        @Override
        public TableProperties getTableProperties(Session session, TableHandle handle) {
            return new TableProperties(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, new ConnectorTableProperties(((PredicatedTableHandle)handle.connectorHandle()).getPredicate(), Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        }
    };
    private final PlannerContext plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(this.metadata).build();
    private final EffectivePredicateExtractor effectivePredicateExtractor = new EffectivePredicateExtractor(this.plannerContext, true);
    private final EffectivePredicateExtractor effectivePredicateExtractorWithoutTableProperties = new EffectivePredicateExtractor(this.plannerContext, false);
    private Map<Symbol, ColumnHandle> scanAssignments;
    private TableScanNode baseTableScan;
    private ExpressionIdentityNormalizer expressionNormalizer;

    @BeforeEach
    public void setUp() {
        this.scanAssignments = ImmutableMap.builder().put((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new TestingMetadata.TestingColumnHandle("a")).put((Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new TestingMetadata.TestingColumnHandle("b")).put((Object)new Symbol((Type)BigintType.BIGINT, "c"), (Object)new TestingMetadata.TestingColumnHandle("c")).put((Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new TestingMetadata.TestingColumnHandle("d")).put((Object)new Symbol((Type)BigintType.BIGINT, "e"), (Object)new TestingMetadata.TestingColumnHandle("e")).put((Object)new Symbol((Type)BigintType.BIGINT, "f"), (Object)new TestingMetadata.TestingColumnHandle("f")).put((Object)new Symbol((Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), "r"), (Object)new TestingMetadata.TestingColumnHandle("r")).buildOrThrow();
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c"), (Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new Symbol((Type)BigintType.BIGINT, "e"), (Object)new Symbol((Type)BigintType.BIGINT, "f"))));
        this.baseTableScan = TableScanNode.newInstance((PlanNodeId)TestEffectivePredicateExtractor.newId(), (TableHandle)TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments, (boolean)false, Optional.empty());
        this.expressionNormalizer = new ExpressionIdentityNormalizer();
    }

    @Test
    public void testAggregation() {
        AggregationNode node = AggregationNode.singleAggregation((PlanNodeId)TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "f")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "d"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(2L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "e"), (Expression)new Reference((Type)BigintType.BIGINT, "f"))})), (Map)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "c"), (Object)new AggregationNode.Aggregation(TestEffectivePredicateExtractor.fakeFunction("test"), (List)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty()), (Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new AggregationNode.Aggregation(TestEffectivePredicateExtractor.fakeFunction("test"), (List)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty())), (AggregationNode.GroupingSetDescriptor)AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c"))));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(2L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c"))}));
    }

    @Test
    public void testGroupByEmpty() {
        AggregationNode node = new AggregationNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)Booleans.FALSE), (Map)ImmutableMap.of(), AggregationNode.globalAggregation(), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)Booleans.TRUE);
    }

    @Test
    public void testFilter() {
        FilterNode node = TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)DoubleType.DOUBLE, "a"), (Expression)this.functionResolution.functionCallBuilder("rand").build()), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testProject() {
        ProjectNode node = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))})), Assignments.of((Symbol)new Symbol((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)new Symbol((Type)BigintType.BIGINT, "e"), (Expression)new Reference((Type)BigintType.BIGINT, "c")));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "d"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e"))}));
    }

    @Test
    public void testProjectWithSymbolReuse() {
        ProjectNode projectReusingB = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))})), Assignments.of((Symbol)new Symbol((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)new Symbol((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")));
        Expression effectivePredicateWhenBReused = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)projectReusingB);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicateWhenBReused)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), TestEffectivePredicateExtractor.bigintLiteral(10L))));
        ProjectNode projectReusingC = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))})), Assignments.builder().put(new Symbol((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "a")).put(new Symbol((Type)BigintType.BIGINT, "e"), (Expression)new Reference((Type)BigintType.BIGINT, "c")).put(new Symbol((Type)BigintType.BIGINT, "f"), (Expression)new Reference((Type)BigintType.BIGINT, "b")).build());
        Expression effectivePredicateWhenCReused = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)projectReusingC);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicateWhenCReused)).isEqualTo(this.normalizeConjuncts(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "f")))));
    }

    @Test
    public void testTopN() {
        TopNNode node = new TopNNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)DoubleType.DOUBLE, "b"), (Expression)new Reference((Type)DoubleType.DOUBLE, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))})), 1L, new OrderingScheme((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), (Map)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)SortOrder.ASC_NULLS_LAST)), TopNNode.Step.PARTIAL);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)DoubleType.DOUBLE, "b"), (Expression)new Reference((Type)DoubleType.DOUBLE, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testLimit() {
        LimitNode node = new LimitNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))})), 1L, false);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testSort() {
        SortNode node = new SortNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))})), new OrderingScheme((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), (Map)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)SortOrder.ASC_NULLS_LAST)), false);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testWindow() {
        WindowNode node = new WindowNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))})), new DataOrganizationSpecification((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), (Map)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)SortOrder.ASC_NULLS_LAST)))), (Map)ImmutableMap.of(), Optional.empty(), (Set)ImmutableSet.of(), 0);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testTableScan() {
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)DoubleType.DOUBLE, "c"), (Object)new Symbol((Type)RealType.REAL, "d"))));
        TableScanNode node = TableScanNode.newInstance((PlanNodeId)TestEffectivePredicateExtractor.newId(), (TableHandle)TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments, (boolean)false, Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)Booleans.TRUE);
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.none()), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.none(), Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)Booleans.FALSE);
        TupleDomain predicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(new Symbol((Type)BigintType.BIGINT, "a")), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)predicate), (List)ImmutableList.copyOf(assignments.keySet()), assignments, predicate, Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), (Expression)new Reference((Type)BigintType.BIGINT, "a"))));
        predicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(new Symbol((Type)BigintType.BIGINT, "a")), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)this.scanAssignments.get(new Symbol((Type)BigintType.BIGINT, "b")), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(new Symbol((Type)BigintType.BIGINT, "a")), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)))), (List)ImmutableList.copyOf(assignments.keySet()), assignments, predicate, Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractorWithoutTableProperties.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(2L), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), (Expression)new Reference((Type)BigintType.BIGINT, "a"))}));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)predicate), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.all(), Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(1L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), TestEffectivePredicateExtractor.bigintLiteral(2L))}));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)predicate), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(new Symbol((Type)BigintType.BIGINT, "a")), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)), (Object)this.scanAssignments.get(new Symbol((Type)BigintType.BIGINT, "b")), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))), Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(2L), (Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), (Expression)new Reference((Type)BigintType.BIGINT, "a"))}));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.all(), Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)Booleans.TRUE);
    }

    @Test
    public void testValues() {
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(3L))))))).isEqualTo((Object)new In((Expression)new Reference((Type)BigintType.BIGINT, "a"), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)TestEffectivePredicateExtractor.bigintLiteral(3L))));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(3L))), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null))))))).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "a")), new In((Expression)new Reference((Type)BigintType.BIGINT, "a"), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)TestEffectivePredicateExtractor.bigintLiteral(3L)))}));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null))))))).isEqualTo((Object)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "a")));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), "r")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)new Constant((Type)UnknownType.UNKNOWN, null))))))))).isEqualTo((Object)Booleans.TRUE);
        List rows = (List)IntStream.range(0, 500).mapToObj(TestEffectivePredicateExtractor::bigintLiteral).map(ImmutableList::of).map(Row::new).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), rows))).isEqualTo((Object)new Between((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(0L), TestEffectivePredicateExtractor.bigintLiteral(499L)));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "c")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.doubleLiteral(Double.NaN))))))).isEqualTo((Object)IrExpressions.not((Metadata)this.functionResolution.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)DoubleType.DOUBLE, "c"))));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "c")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, null))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.doubleLiteral(Double.NaN))))))).isEqualTo((Object)Booleans.TRUE);
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "x")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.doubleLiteral(42.0))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.doubleLiteral(Double.NaN))))))).isEqualTo((Object)IrExpressions.not((Metadata)this.functionResolution.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)DoubleType.DOUBLE, "x"))));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)RealType.REAL, "d")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Cast(TestEffectivePredicateExtractor.doubleLiteral(Double.NaN), (Type)RealType.REAL))))))).isEqualTo((Object)IrExpressions.not((Metadata)this.functionResolution.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)RealType.REAL, "d"))));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)TestEffectivePredicateExtractor.bigintLiteral(100L))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(3L), (Object)TestEffectivePredicateExtractor.bigintLiteral(200L))))))).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{new In((Expression)new Reference((Type)BigintType.BIGINT, "a"), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)TestEffectivePredicateExtractor.bigintLiteral(3L))), new In((Expression)new Reference((Type)BigintType.BIGINT, "b"), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(100L), (Object)TestEffectivePredicateExtractor.bigintLiteral(200L)))}));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)new Constant((Type)BigintType.BIGINT, null))), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null), (Object)TestEffectivePredicateExtractor.bigintLiteral(200L))))))).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{IrUtils.or((Expression[])new Expression[]{new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "a")), new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(1L))}), IrUtils.or((Expression[])new Expression[]{new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "b")), new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), TestEffectivePredicateExtractor.bigintLiteral(200L))})}));
        ResolvedFunction rand = this.functionResolution.resolveFunction("rand", (List<TypeSignatureProvider>)ImmutableList.of());
        ValuesNode node = new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)new Call(rand, (List)ImmutableList.of())))));
        Assertions.assertThat((Object)this.extract((PlanNode)node)).isEqualTo((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(1L)));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L))), (Object)new Row((List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))))))).isEqualTo((Object)Booleans.TRUE);
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)BogusType.BOGUS, "g")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(2L))))))).isEqualTo((Object)Booleans.TRUE);
    }

    private Expression extract(PlanNode node) {
        return (Expression)TransactionBuilder.transaction((TransactionManager)new TestingTransactionManager(), (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SESSION, transactionSession -> this.effectivePredicateExtractor.extract(transactionSession, node));
    }

    @Test
    public void testUnion() {
        ImmutableListMultimap symbolMapping = ImmutableListMultimap.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "c"), (Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "e"));
        UnionNode node = new UnionNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(10L))), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(100L))})), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(100L))}))), (ListMultimap)symbolMapping, (List)ImmutableList.copyOf((Collection)symbolMapping.keySet()));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testInnerJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "a"), new Symbol((Type)BigintType.BIGINT, "d")));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "b"), new Symbol((Type)BigintType.BIGINT, "e")));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c"))));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new Symbol((Type)BigintType.BIGINT, "e"), (Object)new Symbol((Type)BigintType.BIGINT, "f"))));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "g"), TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "f"), TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.INNER, (PlanNode)left, (PlanNode)right, (List)criteria, left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.of(TestEffectivePredicateExtractor.lessThanOrEqual((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "e"))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "f"), TestEffectivePredicateExtractor.bigintLiteral(100L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.lessThanOrEqual((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "e"))}));
    }

    @Test
    public void testInnerJoinPropagatesPredicatesViaEquiConditions() {
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c"))));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new Symbol((Type)BigintType.BIGINT, "e"), (Object)new Symbol((Type)BigintType.BIGINT, "f"))));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, (Expression)TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(10L)));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.INNER, (PlanNode)left, (PlanNode)rightScan, (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "a"), new Symbol((Type)BigintType.BIGINT, "d"))), (List)ImmutableList.of(), rightScan.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testInnerJoinWithFalseFilter() {
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c"))));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new Symbol((Type)BigintType.BIGINT, "e"), (Object)new Symbol((Type)BigintType.BIGINT, "f"))));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.INNER, (PlanNode)leftScan, (PlanNode)rightScan, (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "a"), new Symbol((Type)BigintType.BIGINT, "d"))), leftScan.getOutputSymbols(), rightScan.getOutputSymbols(), false, Optional.of(Booleans.FALSE), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)Booleans.FALSE);
    }

    @Test
    public void testLeftJoin() {
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)TestEffectivePredicateExtractor.tableScanNode(Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c"))))), IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "g"), TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)TestEffectivePredicateExtractor.tableScanNode(Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new Symbol((Type)BigintType.BIGINT, "e"), (Object)new Symbol((Type)BigintType.BIGINT, "f"))))), IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "f"), TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.LEFT, (PlanNode)left, (PlanNode)right, (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "a"), new Symbol((Type)BigintType.BIGINT, "d")), (Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "b"), new Symbol((Type)BigintType.BIGINT, "e"))), left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L)), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "d")), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "e"))})}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "f"), TestEffectivePredicateExtractor.bigintLiteral(100L)), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "f"))}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "d"))}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "e"))})}));
    }

    @Test
    public void testLeftJoinWithFalseInner() {
        ImmutableList criteria = ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "a"), new Symbol((Type)BigintType.BIGINT, "d")));
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c"))));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new Symbol((Type)BigintType.BIGINT, "e"), (Object)new Symbol((Type)BigintType.BIGINT, "f"))));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "g"), TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, (Expression)Booleans.FALSE);
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.LEFT, (PlanNode)left, (PlanNode)right, (List)criteria, left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L)), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "d"))})}));
    }

    @Test
    public void testRightJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "a"), new Symbol((Type)BigintType.BIGINT, "d")));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "b"), new Symbol((Type)BigintType.BIGINT, "e")));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c"))));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new Symbol((Type)BigintType.BIGINT, "e"), (Object)new Symbol((Type)BigintType.BIGINT, "f"))));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "g"), TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "f"), TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.RIGHT, (PlanNode)left, (PlanNode)right, (List)criteria, left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "b")), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "a"))})}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "c"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "c"))}), TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "f"), TestEffectivePredicateExtractor.bigintLiteral(100L)), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "a"))}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "b"))})}));
    }

    @Test
    public void testRightJoinWithFalseInner() {
        ImmutableList criteria = ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "a"), new Symbol((Type)BigintType.BIGINT, "d")));
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c"))));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "d"), (Object)new Symbol((Type)BigintType.BIGINT, "e"), (Object)new Symbol((Type)BigintType.BIGINT, "f"))));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, (Expression)Booleans.FALSE);
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "f"), TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.RIGHT, (PlanNode)left, (PlanNode)right, (List)criteria, left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "f"), TestEffectivePredicateExtractor.bigintLiteral(100L)), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), TestEffectivePredicateExtractor.isNull((Expression)new Reference((Type)BigintType.BIGINT, "a"))})}));
    }

    @Test
    public void testSemiJoin() {
        SemiJoinNode node = new SemiJoinNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(100L))})), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(5L))), new Symbol((Type)BigintType.BIGINT, "a"), new Symbol((Type)BigintType.BIGINT, "b"), new Symbol((Type)DoubleType.DOUBLE, "c"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan((Expression)new Reference((Type)BigintType.BIGINT, "a"), TestEffectivePredicateExtractor.bigintLiteral(100L))})));
    }

    private static TableScanNode tableScanNode(Map<Symbol, ColumnHandle> scanAssignments) {
        return new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(scanAssignments.keySet()), scanAssignments, TupleDomain.all(), Optional.empty(), false, Optional.empty());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }

    private static FilterNode filter(PlanNode source, Expression predicate) {
        return new FilterNode(TestEffectivePredicateExtractor.newId(), source, predicate);
    }

    private static Expression bigintLiteral(long number) {
        return new Constant((Type)BigintType.BIGINT, (Object)number);
    }

    private static Expression doubleLiteral(double value) {
        return new Constant((Type)DoubleType.DOUBLE, (Object)value);
    }

    private static Comparison equals(Expression expression1, Expression expression2) {
        return new Comparison(Comparison.Operator.EQUAL, expression1, expression2);
    }

    private static Comparison lessThan(Expression expression1, Expression expression2) {
        return new Comparison(Comparison.Operator.LESS_THAN, expression1, expression2);
    }

    private static Comparison lessThanOrEqual(Expression expression1, Expression expression2) {
        return new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, expression1, expression2);
    }

    private static Comparison greaterThan(Expression expression1, Expression expression2) {
        return new Comparison(Comparison.Operator.GREATER_THAN, expression1, expression2);
    }

    private static IsNull isNull(Expression expression) {
        return new IsNull(expression);
    }

    private static ResolvedFunction fakeFunction(String name) {
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)name), (Type)UnknownType.UNKNOWN, (List)ImmutableList.of());
        return new ResolvedFunction(boundSignature, GlobalSystemConnector.CATALOG_HANDLE, FunctionId.toFunctionId((String)name, (Signature)boundSignature.toSignature()), FunctionKind.SCALAR, true, new FunctionNullability(false, (List)ImmutableList.of()), (Map)ImmutableMap.of(), (Set)ImmutableSet.of());
    }

    private Set<Expression> normalizeConjuncts(Expression ... conjuncts) {
        return this.normalizeConjuncts(Arrays.asList(conjuncts));
    }

    private Set<Expression> normalizeConjuncts(Collection<Expression> conjuncts) {
        return this.normalizeConjuncts(IrUtils.combineConjuncts(conjuncts));
    }

    private Set<Expression> normalizeConjuncts(Expression predicate) {
        predicate = this.expressionNormalizer.normalize(predicate);
        EqualityInference inference = new EqualityInference(new Expression[]{predicate});
        Set scope = SymbolsExtractor.extractUnique((Expression)predicate);
        Set<Expression> rewrittenSet = EqualityInference.nonInferrableConjuncts((Expression)predicate).map(expression -> inference.rewrite(expression, scope)).peek(rewritten -> Preconditions.checkState((rewritten != null ? 1 : 0) != 0, (Object)"Rewrite with full symbol scope should always be possible")).collect(Collectors.toSet());
        rewrittenSet.addAll(inference.generateEqualitiesPartitionedBy(scope).getScopeEqualities());
        return rewrittenSet;
    }

    private static TableHandle makeTableHandle(TupleDomain<ColumnHandle> predicate) {
        return new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new PredicatedTableHandle(predicate), (ConnectorTransactionHandle)TestingTransactionHandle.create());
    }

    private static class ExpressionIdentityNormalizer {
        private final Map<Expression, Expression> expressionCache = new HashMap<Expression, Expression>();

        private ExpressionIdentityNormalizer() {
        }

        private Expression normalize(Expression expression) {
            Expression identityNormalizedExpression = this.expressionCache.get(expression);
            if (identityNormalizedExpression == null) {
                IrUtils.preOrder((Expression)expression).filter(e -> !e.equals((Object)expression)).forEach(this::normalize);
                identityNormalizedExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionNodeInliner(this.expressionCache), (Expression)expression);
                this.expressionCache.put(identityNormalizedExpression, identityNormalizedExpression);
            }
            return identityNormalizedExpression;
        }
    }

    private static class PredicatedTableHandle
    implements ConnectorTableHandle {
        private final TupleDomain<ColumnHandle> predicate;

        public PredicatedTableHandle(TupleDomain<ColumnHandle> predicate) {
            this.predicate = predicate;
        }

        public TupleDomain<ColumnHandle> getPredicate() {
            return this.predicate;
        }
    }
}

