/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.Assignments;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class SymbolAliases {
    private final Map<String, Reference> map;

    public SymbolAliases() {
        this.map = ImmutableMap.of();
    }

    private SymbolAliases(Map<String, Reference> aliases) {
        this.map = ImmutableMap.copyOf(Objects.requireNonNull(aliases, "aliases is null"));
    }

    public Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteReference(Reference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return (Expression)SymbolAliases.this.map.getOrDefault(node.name(), node);
            }
        }, (Expression)expression);
    }

    public static Builder builder() {
        return new Builder();
    }

    public SymbolAliases withNewAliases(SymbolAliases sourceAliases) {
        Builder builder = new Builder(this);
        for (Map.Entry<String, Reference> alias : sourceAliases.map.entrySet()) {
            builder.put(alias.getKey(), alias.getValue());
        }
        return builder.build();
    }

    public Symbol getSymbol(String alias) {
        return Symbol.from((Expression)this.get(alias));
    }

    public Reference get(String alias) {
        return this.getOptional(alias).orElseThrow(() -> new IllegalStateException(String.format("missing expression for alias %s", alias)));
    }

    public Optional<Reference> getOptional(String alias) {
        Reference result = this.map.get(alias);
        return Optional.ofNullable(result);
    }

    private Map<String, Reference> getUpdatedAssignments(Assignments assignments) {
        ImmutableMap.Builder mapUpdate = ImmutableMap.builder();
        for (Map.Entry assignment : assignments.getMap().entrySet()) {
            for (Map.Entry<String, Reference> existingAlias : this.map.entrySet()) {
                if (((Expression)assignment.getValue()).equals((Object)existingAlias.getValue())) {
                    mapUpdate.put((Object)existingAlias.getKey(), (Object)((Symbol)assignment.getKey()).toSymbolReference());
                    continue;
                }
                if (!((Symbol)assignment.getKey()).toSymbolReference().equals((Object)existingAlias.getValue())) continue;
                mapUpdate.put((Object)existingAlias.getKey(), (Object)existingAlias.getValue());
            }
        }
        return mapUpdate.buildOrThrow();
    }

    public SymbolAliases updateAssignments(Assignments assignments) {
        return SymbolAliases.builder().putAll(this).putUnchecked(this.getUpdatedAssignments(assignments)).build();
    }

    public SymbolAliases replaceAssignments(Assignments assignments) {
        return new SymbolAliases(this.getUpdatedAssignments(assignments));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.map).toString();
    }

    public static class Builder {
        Map<String, Reference> bindings;

        private Builder() {
            this.bindings = new HashMap<String, Reference>();
        }

        private Builder(SymbolAliases initialAliases) {
            this.bindings = new HashMap<String, Reference>(initialAliases.map);
        }

        public Builder put(String alias, Reference reference) {
            Objects.requireNonNull(alias, "alias is null");
            Objects.requireNonNull(reference, "symbolReference is null");
            if (this.bindings.containsKey(alias) && this.bindings.get(alias).equals((Object)reference)) {
                return this;
            }
            Preconditions.checkState((!this.bindings.containsKey(alias) ? 1 : 0) != 0, (String)"Alias '%s' already bound to expression '%s'. Tried to rebind to '%s'", (Object)alias, (Object)this.bindings.get(alias), (Object)reference);
            this.bindings.put(alias, reference);
            return this;
        }

        public Builder putAll(Map<String, Reference> aliases) {
            aliases.entrySet().forEach(entry -> this.put((String)entry.getKey(), (Reference)entry.getValue()));
            return this;
        }

        private Builder putUnchecked(Map<String, Reference> aliases) {
            this.bindings.putAll(aliases);
            return this;
        }

        public Builder putAll(SymbolAliases aliases) {
            return this.putAll(aliases.map);
        }

        public SymbolAliases build() {
            return new SymbolAliases(this.bindings);
        }
    }
}

