/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestMinMaxNWindow {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testMax() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT max(x, 3) OVER () FROM (VALUES 1, 2, 3, 4, 5) t(x)\n"))).matches("VALUES\n    (ARRAY[5, 4, 3]),\n    (ARRAY[5, 4, 3]),\n    (ARRAY[5, 4, 3]),\n    (ARRAY[5, 4, 3]),\n    (ARRAY[5, 4, 3])\n");
    }

    @Test
    public void testMin() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT min(x, 3) OVER () FROM (VALUES 1, 2, 3, 4, 5) t(x)\n"))).matches("VALUES\n    (ARRAY[1, 2, 3]),\n    (ARRAY[1, 2, 3]),\n    (ARRAY[1, 2, 3]),\n    (ARRAY[1, 2, 3]),\n    (ARRAY[1, 2, 3])\n");
    }
}

