/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBigintType
extends AbstractTestType {
    public TestBigintType() {
        super((Type)BigintType.BIGINT, Long.class, TestBigintType.createTestBlock());
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(15);
        BigintType.BIGINT.writeLong(blockBuilder, 1111L);
        BigintType.BIGINT.writeLong(blockBuilder, 1111L);
        BigintType.BIGINT.writeLong(blockBuilder, 1111L);
        BigintType.BIGINT.writeLong(blockBuilder, 2222L);
        BigintType.BIGINT.writeLong(blockBuilder, 2222L);
        BigintType.BIGINT.writeLong(blockBuilder, 2222L);
        BigintType.BIGINT.writeLong(blockBuilder, 2222L);
        BigintType.BIGINT.writeLong(blockBuilder, 2222L);
        BigintType.BIGINT.writeLong(blockBuilder, 3333L);
        BigintType.BIGINT.writeLong(blockBuilder, 3333L);
        BigintType.BIGINT.writeLong(blockBuilder, 4444L);
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Long)value + 1L;
    }

    @Test
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assertions.assertThat((Object)range.getMin()).isEqualTo((Object)Long.MIN_VALUE);
        Assertions.assertThat((Object)range.getMax()).isEqualTo((Object)Long.MAX_VALUE);
    }

    @Test
    public void testPreviousValue() {
        long minValue = Long.MIN_VALUE;
        long maxValue = Long.MAX_VALUE;
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEqualTo(Optional.of(1110L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue - 2L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(maxValue - 1L));
    }

    @Test
    public void testNextValue() {
        long minValue = Long.MIN_VALUE;
        long maxValue = Long.MAX_VALUE;
        Assertions.assertThat((Optional)this.type.getNextValue((Object)minValue)).isEqualTo(Optional.of(minValue + 1L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue + 2L));
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEqualTo(Optional.of(1112L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }
}

