/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.jaxrs.AsyncResponseHandler;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.TimeoutHandler;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class DisconnectionAwareAsyncResponse
implements AsyncResponse {
    private final AtomicBoolean clientDisconnected = new AtomicBoolean();
    private final AsyncContext asyncContext;
    private final AsyncResponse delegate;
    private final AtomicReference<ListenableFuture<?>> cancellableFuture = new AtomicReference<Object>(null);

    public DisconnectionAwareAsyncResponse(@Context HttpServletRequest request, AsyncResponse delegate) {
        Objects.requireNonNull(request, "request is null");
        Objects.requireNonNull(delegate, "delegate is null");
        Verify.verify((boolean)request.isAsyncStarted(), (String)"AsyncContext is not started, did you forget @Suspended?", (Object[])new Object[0]);
        this.delegate = delegate;
        this.asyncContext = request.getAsyncContext();
        request.getAsyncContext().addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) {
            }

            public void onTimeout(AsyncEvent event) {
            }

            public void onError(AsyncEvent event) {
                if (DisconnectionAwareAsyncResponse.wasRequestTerminated(event.getThrowable()) && DisconnectionAwareAsyncResponse.this.clientDisconnected.compareAndSet(false, true)) {
                    DisconnectionAwareAsyncResponse.this.asyncContext.complete();
                    ListenableFuture future = DisconnectionAwareAsyncResponse.this.cancellableFuture.getAndSet(null);
                    if (future != null) {
                        future.cancel(true);
                    }
                }
            }

            public void onStartAsync(AsyncEvent event) {
            }
        });
    }

    public DisconnectionAwareAsyncResponse withCancellableFuture(ListenableFuture<?> future) {
        Preconditions.checkState((boolean)this.cancellableFuture.compareAndSet(null, future), (Object)"Cancellable future already set");
        return this;
    }

    public boolean resume(Object response) {
        if (this.clientDisconnected.get()) {
            return true;
        }
        return this.delegate.resume(response);
    }

    public boolean resume(Throwable response) {
        if (this.clientDisconnected.get()) {
            return true;
        }
        return this.delegate.resume(response);
    }

    public boolean cancel() {
        if (this.clientDisconnected.get()) {
            return true;
        }
        return this.delegate.cancel();
    }

    public boolean cancel(int retryAfter) {
        if (this.clientDisconnected.get()) {
            return true;
        }
        return this.delegate.cancel(retryAfter);
    }

    public boolean cancel(Date retryAfter) {
        if (this.clientDisconnected.get()) {
            return true;
        }
        return this.delegate.cancel(retryAfter);
    }

    public boolean isSuspended() {
        return this.delegate.isSuspended();
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        if (this.clientDisconnected.get()) {
            return true;
        }
        return this.delegate.isDone();
    }

    public boolean setTimeout(long time, TimeUnit unit) {
        return this.delegate.setTimeout(time, unit);
    }

    public void setTimeoutHandler(TimeoutHandler handler) {
        this.delegate.setTimeoutHandler(handler);
    }

    public Collection<Class<?>> register(Class<?> callback) {
        return this.delegate.register(callback);
    }

    public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
        return this.delegate.register(callback, (Class[])callbacks);
    }

    public Collection<Class<?>> register(Object callback) {
        return this.delegate.register(callback);
    }

    public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
        return this.delegate.register(callback, callbacks);
    }

    private static boolean wasRequestTerminated(Throwable throwable) {
        IOException ioException;
        return throwable instanceof IOException && (ioException = (IOException)throwable).getMessage().contains("cancel_stream_error");
    }

    public static AsyncResponseHandler bindDisconnectionAwareAsyncResponse(DisconnectionAwareAsyncResponse asyncResponse, ListenableFuture<?> futureResponse, Executor httpResponseExecutor) {
        return AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse.withCancellableFuture(futureResponse), futureResponse, (Executor)httpResponseExecutor);
    }
}

