/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import io.airlift.compress.v3.zstd.ZstdCompressor;
import io.airlift.compress.v3.zstd.ZstdDecompressor;
import io.trino.server.ProtocolConfig;
import java.nio.charset.StandardCharsets;

public class PreparedStatementEncoder {
    private static final String PREFIX = "$zstd:";
    private final int compressionThreshold;
    private final int compressionMinGain;

    @Inject
    public PreparedStatementEncoder(ProtocolConfig protocolConfig) {
        this.compressionThreshold = protocolConfig.getPreparedStatementCompressionThreshold();
        this.compressionMinGain = protocolConfig.getPreparedStatementCompressionMinimalGain();
    }

    public String encodePreparedStatementForHeader(String preparedStatement) {
        if (preparedStatement.length() < this.compressionThreshold) {
            return preparedStatement;
        }
        ZstdCompressor compressor = ZstdCompressor.create();
        byte[] inputBytes = preparedStatement.getBytes(StandardCharsets.UTF_8);
        byte[] compressed = new byte[compressor.maxCompressedLength(inputBytes.length)];
        int outputSize = compressor.compress(inputBytes, 0, inputBytes.length, compressed, 0, compressed.length);
        String encoded = BaseEncoding.base64Url().encode(compressed, 0, outputSize);
        if (encoded.length() + PREFIX.length() + this.compressionMinGain > preparedStatement.length()) {
            return preparedStatement;
        }
        return PREFIX + encoded;
    }

    public String decodePreparedStatementFromHeader(String headerValue) {
        if (!headerValue.startsWith(PREFIX)) {
            return headerValue;
        }
        String encoded = headerValue.substring(PREFIX.length());
        byte[] compressed = BaseEncoding.base64Url().decode((CharSequence)encoded);
        ZstdDecompressor decompressor = ZstdDecompressor.create();
        byte[] preparedStatement = new byte[Math.toIntExact(decompressor.getDecompressedSize(compressed, 0, compressed.length))];
        decompressor.decompress(compressed, 0, compressed.length, preparedStatement, 0, preparedStatement.length);
        return new String(preparedStatement, StandardCharsets.UTF_8);
    }
}

