/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.client.Column;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.ProtocolUtil;
import io.trino.server.protocol.spooling.SpooledBlock;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryResultRows {
    private final Session session;
    private final Optional<List<OutputColumn>> columns;
    private final List<Page> pages;
    private final long totalRows;

    private QueryResultRows(Session session, Optional<List<OutputColumn>> columns, List<Page> pages) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.columns = Objects.requireNonNull(columns, "columns is null").map(values -> (List)values.stream().filter(column -> !this.isSpooledMetadataColumn((OutputColumn)column)).collect(ImmutableList.toImmutableList()));
        this.pages = ImmutableList.copyOf(pages);
        this.totalRows = QueryResultRows.countRows(pages);
        Verify.verify((this.totalRows == 0L || this.totalRows > 0L && columns.isPresent() ? 1 : 0) != 0, (String)"data present without columns and types", (Object[])new Object[0]);
    }

    private boolean isSpooledMetadataColumn(OutputColumn column) {
        return column.type().equals((Object)SpooledBlock.SPOOLING_METADATA_TYPE);
    }

    public boolean isEmpty() {
        return this.totalRows == 0L;
    }

    public Optional<List<OutputColumn>> getOutputColumns() {
        return this.columns;
    }

    public Optional<List<Column>> getColumns() {
        return this.columns.map(columns -> (List)columns.stream().map(value -> ProtocolUtil.createColumn(value.columnName(), value.type(), true)).collect(ImmutableList.toImmutableList()));
    }

    public List<Page> getPages() {
        return this.pages;
    }

    @VisibleForTesting
    public long getTotalRowsCount() {
        return this.totalRows;
    }

    public Optional<Long> getUpdateCount() {
        if (this.totalRows != 1L || this.columns.isEmpty()) {
            return Optional.empty();
        }
        List<OutputColumn> columns = this.columns.get();
        if (columns.size() != 1 || !columns.get(0).type().equals((Object)BigintType.BIGINT)) {
            return Optional.empty();
        }
        Preconditions.checkState((!this.pages.isEmpty() ? 1 : 0) != 0, (Object)"no data pages available");
        Number value = (Number)columns.get(0).type().getObjectValue(this.session.toConnectorSession(), this.pages.getFirst().getBlock(0), 0);
        return Optional.ofNullable(value).map(Number::longValue);
    }

    private static long countRows(List<Page> pages) {
        long rows = 0L;
        for (Page page : pages) {
            rows += (long)page.getPositionCount();
        }
        return rows;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).add("totalRowsCount", this.getTotalRowsCount()).add("pagesCount", this.pages.size()).toString();
    }

    public static QueryResultRows empty(Session session) {
        return new QueryResultRows(session, Optional.empty(), (List<Page>)ImmutableList.of());
    }

    public static Builder queryResultRowsBuilder(Session session) {
        return new Builder(session);
    }

    public static class Builder {
        private final Session session;
        private ImmutableList.Builder<Page> pages = ImmutableList.builder();
        private Optional<List<OutputColumn>> columns = Optional.empty();

        public Builder(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public Builder addPage(Page page) {
            this.pages.add((Object)page);
            return this;
        }

        public Builder addPages(List<Page> page) {
            this.pages.addAll(page);
            return this;
        }

        public Builder withColumnsAndTypes(@Nullable List<Column> columns, @Nullable List<Type> types) {
            if (columns != null || types != null) {
                this.columns = Optional.of(Builder.combine(columns, types));
            }
            return this;
        }

        public Builder withSingleBooleanValue(Column column, boolean value) {
            BlockBuilder blockBuilder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(1);
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, value);
            this.pages = ImmutableList.builder().add((Object)new Page(new Block[]{blockBuilder.build()}));
            this.columns = Optional.of(Builder.combine((List<Column>)ImmutableList.of((Object)column), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)));
            return this;
        }

        public QueryResultRows build() {
            return new QueryResultRows(this.session, this.columns, (List<Page>)this.pages.build());
        }

        private static List<OutputColumn> combine(@Nullable List<Column> columns, @Nullable List<Type> types) {
            Preconditions.checkArgument((columns != null && types != null ? 1 : 0) != 0, (Object)"columns and types must be present at the same time");
            Preconditions.checkArgument((columns.size() == types.size() ? 1 : 0) != 0, (Object)"columns and types size mismatch");
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)columns.size());
            for (int i = 0; i < columns.size(); ++i) {
                builder.add((Object)new OutputColumn(i, columns.get(i).getName(), types.get(i)));
            }
            return builder.build();
        }
    }
}

