/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.client.QueryData;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.EncodedQueryData;
import io.trino.client.spooling.Segment;
import io.trino.server.ExternalUriInfo;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.QueryResultRows;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.QueryDataProducer;
import io.trino.server.protocol.spooling.SegmentResource;
import io.trino.server.protocol.spooling.SpooledBlock;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.protocol.SpooledLocation;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class SpooledQueryDataProducer
implements QueryDataProducer {
    private final QueryDataEncoder.Factory encoderFactory;
    private final AtomicBoolean metadataWritten = new AtomicBoolean(false);
    private long currentOffset;

    public SpooledQueryDataProducer(QueryDataEncoder.Factory encoderFactory) {
        this.encoderFactory = Objects.requireNonNull(encoderFactory, "encoderFactory is null");
    }

    @Override
    public QueryData produce(ExternalUriInfo uriInfo, Session session, QueryResultRows rows, Consumer<TrinoException> throwableConsumer) {
        if (rows.isEmpty()) {
            return null;
        }
        UriBuilder uriBuilder = SegmentResource.spooledSegmentUriBuilder(uriInfo);
        QueryDataEncoder encoder = this.encoderFactory.create(session, rows.getOutputColumns().orElseThrow());
        EncodedQueryData.Builder builder = EncodedQueryData.builder((String)encoder.encoding());
        List<OutputColumn> outputColumns = rows.getOutputColumns().orElseThrow();
        if (this.metadataWritten.compareAndSet(false, true)) {
            builder.withAttributes(encoder.attributes());
        }
        try {
            for (Page page : rows.getPages()) {
                DataAttributes attributes;
                if (this.hasSpoolingMetadata(page, outputColumns)) {
                    SpooledLocation spooledLocation;
                    SpooledBlock metadata = SpooledBlock.deserialize(page);
                    attributes = metadata.attributes().toBuilder().set(DataAttribute.ROW_OFFSET, (Object)this.currentOffset).build();
                    Objects.requireNonNull(metadata.location());
                    int n = 0;
                    builder.withSegment(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpooledLocation.CoordinatorLocation.class, SpooledLocation.DirectLocation.class}, (Object)spooledLocation, n)) {
                        default -> throw new MatchException(null, null);
                        case 0 -> {
                            SpooledLocation.CoordinatorLocation coordinatorLocation = (SpooledLocation.CoordinatorLocation)spooledLocation;
                            yield Segment.spooled((URI)this.buildSegmentURI(uriBuilder, coordinatorLocation.identifier()), (DataAttributes)attributes, (Map)coordinatorLocation.headers());
                        }
                        case 1 -> {
                            SpooledLocation.DirectLocation directLocation = (SpooledLocation.DirectLocation)spooledLocation;
                            yield Segment.spooled((URI)directLocation.uri(), (DataAttributes)attributes, (Map)directLocation.headers());
                        }
                    });
                    this.currentOffset += ((Long)attributes.get(DataAttribute.ROWS_COUNT, Long.class)).longValue();
                    continue;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                attributes = encoder.encodeTo(output, List.of(page)).toBuilder().set(DataAttribute.ROW_OFFSET, (Object)this.currentOffset).build();
                builder.withSegment(Segment.inlined((byte[])output.toByteArray(), (DataAttributes)attributes));
                this.currentOffset += (long)page.getPositionCount();
            }
        }
        catch (IOException e) {
            throwableConsumer.accept(new TrinoException((ErrorCodeSupplier)StandardErrorCode.SERIALIZATION_ERROR, "Failed to serialize query data", (Throwable)e));
        }
        catch (TrinoException e) {
            throwableConsumer.accept(e);
            return null;
        }
        return builder.build();
    }

    private URI buildSegmentURI(UriBuilder builder, Slice identifier) {
        return builder.clone().build(new Object[]{identifier.toStringUtf8()});
    }

    private boolean hasSpoolingMetadata(Page page, List<OutputColumn> outputColumns) {
        return page.getChannelCount() == outputColumns.size() + 1 && page.getPositionCount() == 1 && !page.getBlock(outputColumns.size()).isNull(0);
    }

    public static QueryDataProducer createSpooledQueryDataProducer(QueryDataEncoder.Factory encoder) {
        return new SpooledQueryDataProducer(encoder);
    }
}

