/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.server.protocol.spooling.SpoolingConfig;
import io.trino.server.protocol.spooling.SpoolingManagerRegistry;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.protocol.SpooledLocation;
import io.trino.spi.protocol.SpooledSegmentHandle;
import io.trino.spi.protocol.SpoolingContext;
import io.trino.spi.protocol.SpoolingManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class SpoolingManagerBridge
implements SpoolingManager {
    private final SpoolingManagerRegistry registry;
    private final DataSize initialSegmentSize;
    private final DataSize maximumSegmentSize;
    private final boolean inlineSegments;
    private final SecretKey secretKey;
    private final boolean directStorageAccess;
    private final boolean directStorageFallback;

    @Inject
    public SpoolingManagerBridge(SpoolingConfig spoolingConfig, SpoolingManagerRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
        Objects.requireNonNull(spoolingConfig, "spoolingConfig is null");
        this.initialSegmentSize = spoolingConfig.getInitialSegmentSize();
        this.maximumSegmentSize = spoolingConfig.getMaximumSegmentSize();
        this.inlineSegments = spoolingConfig.isInlineSegments();
        this.directStorageAccess = spoolingConfig.isDirectStorageAccess();
        this.directStorageFallback = spoolingConfig.isDirectStorageFallback();
        this.secretKey = spoolingConfig.getSharedEncryptionKey().orElseThrow(() -> new IllegalArgumentException("protocol.spooling.shared-secret-key is not set"));
    }

    public long maximumSegmentSize() {
        return this.maximumSegmentSize.toBytes();
    }

    public long initialSegmentSize() {
        return this.initialSegmentSize.toBytes();
    }

    public boolean allowSegmentInlining() {
        return this.inlineSegments && this.delegate().allowSegmentInlining();
    }

    public SpooledSegmentHandle create(SpoolingContext context) {
        return this.delegate().create(context);
    }

    public OutputStream createOutputStream(SpooledSegmentHandle handle) throws IOException {
        return this.delegate().createOutputStream(handle);
    }

    public InputStream openInputStream(SpooledSegmentHandle handle) throws IOException {
        return this.delegate().openInputStream(handle);
    }

    public void acknowledge(SpooledSegmentHandle handle) throws IOException {
        this.delegate().acknowledge(handle);
    }

    public SpooledLocation location(SpooledSegmentHandle handle) {
        SpooledLocation spooledLocation = this.delegate().location(handle);
        Objects.requireNonNull(spooledLocation);
        SpooledLocation spooledLocation2 = spooledLocation;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpooledLocation.DirectLocation.class, SpooledLocation.CoordinatorLocation.class}, (Object)spooledLocation2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                SpooledLocation.DirectLocation directLocation;
                yield directLocation = (SpooledLocation.DirectLocation)spooledLocation2;
            }
            case 1 -> {
                SpooledLocation.CoordinatorLocation coordinatorLocation = (SpooledLocation.CoordinatorLocation)spooledLocation2;
                yield SpooledLocation.coordinatorLocation((Slice)SpoolingManagerBridge.toUri(this.secretKey, coordinatorLocation.identifier()), (Map)coordinatorLocation.headers());
            }
        };
    }

    public Optional<SpooledLocation.DirectLocation> directLocation(SpooledSegmentHandle handle) throws IOException {
        if (!this.directStorageAccess) {
            return Optional.empty();
        }
        try {
            return this.delegate().directLocation(handle);
        }
        catch (UnsupportedOperationException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "Direct storage access is enabled but not supported by " + this.delegate().getClass().getSimpleName(), (Throwable)e);
        }
        catch (IOException e) {
            if (this.directStorageFallback) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public SpooledSegmentHandle handle(SpooledLocation location) {
        SpooledLocation spooledLocation = location;
        Objects.requireNonNull(spooledLocation);
        SpooledLocation spooledLocation2 = spooledLocation;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpooledLocation.DirectLocation.class, SpooledLocation.CoordinatorLocation.class}, (Object)spooledLocation2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                throw new IllegalArgumentException("Cannot convert direct location to handle");
            }
            case 1: 
        }
        SpooledLocation.CoordinatorLocation coordinatorLocation = (SpooledLocation.CoordinatorLocation)spooledLocation2;
        return this.delegate().handle((SpooledLocation)SpooledLocation.coordinatorLocation((Slice)SpoolingManagerBridge.fromUri(this.secretKey, coordinatorLocation.identifier()), (Map)coordinatorLocation.headers()));
    }

    private SpoolingManager delegate() {
        return this.registry.getSpoolingManager().orElseThrow(() -> new IllegalStateException("Spooling manager is not loaded"));
    }

    private static Slice toUri(SecretKey secretKey, Slice input) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKey);
            return Slices.utf8Slice((String)Base64.getUrlEncoder().encodeToString(cipher.doFinal(input.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not encode segment identifier to URI", e);
        }
    }

    private static Slice fromUri(SecretKey secretKey, Slice input) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKey);
            return Slices.wrappedBuffer((byte[])cipher.doFinal(Base64.getUrlDecoder().decode(input.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not decode segment identifier from URI", e);
        }
    }
}

