/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DereferencePushdown;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.UnnestNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PushDownDereferenceThroughUnnest
implements Rule<ProjectNode> {
    private static final Capture<UnnestNode> CHILD = Capture.newCapture();

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(Patterns.unnest().capturedAs(CHILD)));
    }

    @Override
    public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
        UnnestNode unnestNode = (UnnestNode)captures.get(CHILD);
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        expressionsBuilder.addAll(projectNode.getAssignments().getExpressions());
        Set dereferences = DereferencePushdown.extractRowSubscripts((Collection<Expression>)expressionsBuilder.build(), false);
        dereferences = (Set)dereferences.stream().filter(expression -> unnestNode.getReplicateSymbols().contains(DereferencePushdown.getBase(expression))).collect(ImmutableSet.toImmutableSet());
        if (dereferences.isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments dereferenceAssignments = Assignments.of(dereferences, context.getSymbolAllocator());
        Map mappings = (Map)HashBiMap.create(dereferenceAssignments.getMap()).inverse().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
        Assignments newAssignments = projectNode.getAssignments().rewrite(expression -> ExpressionNodeInliner.replaceExpression(expression, mappings));
        ProjectNode source = new ProjectNode(context.getIdAllocator().getNextId(), unnestNode.getSource(), Assignments.builder().putIdentities(unnestNode.getSource().getOutputSymbols()).putAll(dereferenceAssignments).build());
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new UnnestNode(context.getIdAllocator().getNextId(), source, (List<Symbol>)ImmutableList.builder().addAll(unnestNode.getReplicateSymbols()).addAll(dereferenceAssignments.getSymbols()).build(), unnestNode.getMappings(), unnestNode.getOrdinalitySymbol(), unnestNode.getJoinType()), newAssignments));
    }
}

