/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.AggregationFunctionMetadata;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.type.FunctionType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public class AggregationNode
extends PlanNode {
    private final PlanNode source;
    private final Map<Symbol, Aggregation> aggregations;
    private final GroupingSetDescriptor groupingSets;
    private final List<Symbol> preGroupedSymbols;
    private final Step step;
    private final Optional<Symbol> hashSymbol;
    private final Optional<Symbol> groupIdSymbol;
    private final List<Symbol> outputs;

    public static AggregationNode singleAggregation(PlanNodeId id, PlanNode source, Map<Symbol, Aggregation> aggregations, GroupingSetDescriptor groupingSets) {
        return new AggregationNode(id, source, aggregations, groupingSets, (List<Symbol>)ImmutableList.of(), Step.SINGLE, Optional.empty(), Optional.empty());
    }

    @JsonCreator
    public AggregationNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="aggregations") Map<Symbol, Aggregation> aggregations, @JsonProperty(value="groupingSets") GroupingSetDescriptor groupingSets, @JsonProperty(value="preGroupedSymbols") List<Symbol> preGroupedSymbols, @JsonProperty(value="step") Step step, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="groupIdSymbol") Optional<Symbol> groupIdSymbol) {
        super(id);
        this.source = source;
        this.aggregations = ImmutableMap.copyOf(Objects.requireNonNull(aggregations, "aggregations is null"));
        aggregations.values().forEach(aggregation -> aggregation.verifyArguments(step));
        Objects.requireNonNull(groupingSets, "groupingSets is null");
        groupIdSymbol.ifPresent(symbol -> Preconditions.checkArgument((boolean)groupingSets.getGroupingKeys().contains(symbol), (Object)"Grouping columns does not contain groupId column"));
        this.groupingSets = groupingSets;
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
        boolean noOrderBy = aggregations.values().stream().map(Aggregation::getOrderingScheme).noneMatch(Optional::isPresent);
        Preconditions.checkArgument((noOrderBy || step == Step.SINGLE ? 1 : 0) != 0, (Object)"ORDER BY does not support distributed aggregation");
        this.step = step;
        this.hashSymbol = hashSymbol;
        Objects.requireNonNull(preGroupedSymbols, "preGroupedSymbols is null");
        Preconditions.checkArgument((preGroupedSymbols.isEmpty() || groupingSets.getGroupingKeys().containsAll(preGroupedSymbols) ? 1 : 0) != 0, (Object)"Pre-grouped symbols must be a subset of the grouping keys");
        this.preGroupedSymbols = ImmutableList.copyOf(preGroupedSymbols);
        ImmutableList.Builder outputs = ImmutableList.builder();
        outputs.addAll(groupingSets.getGroupingKeys());
        hashSymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)outputs).add(arg_0));
        outputs.addAll(aggregations.keySet());
        this.outputs = outputs.build();
    }

    public List<Symbol> getGroupingKeys() {
        return this.groupingSets.getGroupingKeys();
    }

    @JsonProperty(value="groupingSets")
    public GroupingSetDescriptor getGroupingSets() {
        return this.groupingSets;
    }

    public boolean hasSingleGlobalAggregation() {
        return this.hasEmptyGroupingSet() && this.getGroupingSetCount() == 1;
    }

    public boolean hasDefaultOutput() {
        return this.hasEmptyGroupingSet() && (this.step.isOutputPartial() || this.step == Step.SINGLE);
    }

    public boolean hasEmptyGroupingSet() {
        return !this.groupingSets.getGlobalGroupingSets().isEmpty();
    }

    public boolean hasNonEmptyGroupingSet() {
        return this.groupingSets.getGroupingSetCount() > this.groupingSets.getGlobalGroupingSets().size();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty
    public Map<Symbol, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty(value="preGroupedSymbols")
    public List<Symbol> getPreGroupedSymbols() {
        return this.preGroupedSymbols;
    }

    public int getGroupingSetCount() {
        return this.groupingSets.getGroupingSetCount();
    }

    public Set<Integer> getGlobalGroupingSets() {
        return this.groupingSets.getGlobalGroupingSets();
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="step")
    public Step getStep() {
        return this.step;
    }

    @JsonProperty(value="hashSymbol")
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty(value="groupIdSymbol")
    public Optional<Symbol> getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    public boolean hasOrderings() {
        return this.aggregations.values().stream().map(Aggregation::getOrderingScheme).anyMatch(Optional::isPresent);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return AggregationNode.builderFrom(this).setSource((PlanNode)Iterables.getOnlyElement(newChildren)).build();
    }

    public boolean producesDistinctRows() {
        return this.aggregations.isEmpty() && !this.groupingSets.getGroupingKeys().isEmpty() && this.outputs.size() == this.groupingSets.getGroupingKeys().size();
    }

    public boolean isDecomposable(Session session, Metadata metadata) {
        boolean hasOrderBy = this.getAggregations().values().stream().map(Aggregation::getOrderingScheme).anyMatch(Optional::isPresent);
        boolean hasDistinct = this.getAggregations().values().stream().anyMatch(Aggregation::isDistinct);
        boolean decomposableFunctions = this.getAggregations().values().stream().map(Aggregation::getResolvedFunction).map(resolvedFunction -> metadata.getAggregationFunctionMetadata(session, (ResolvedFunction)resolvedFunction)).allMatch(AggregationFunctionMetadata::isDecomposable);
        return !hasOrderBy && !hasDistinct && decomposableFunctions;
    }

    public boolean hasSingleNodeExecutionPreference(Session session, Metadata metadata) {
        return this.hasEmptyGroupingSet() && !this.hasNonEmptyGroupingSet() || this.hasDefaultOutput() && !this.isDecomposable(session, metadata);
    }

    public boolean isStreamable() {
        return ImmutableSet.copyOf(this.preGroupedSymbols).equals((Object)ImmutableSet.copyOf(this.groupingSets.getGroupingKeys())) && this.groupingSets.getGroupingSetCount() == 1 && this.groupingSets.getGlobalGroupingSets().isEmpty();
    }

    public static GroupingSetDescriptor globalAggregation() {
        return AggregationNode.singleGroupingSet((List<Symbol>)ImmutableList.of());
    }

    public static GroupingSetDescriptor singleGroupingSet(List<Symbol> groupingKeys) {
        ImmutableSet globalGroupingSets = groupingKeys.isEmpty() ? ImmutableSet.of((Object)0) : ImmutableSet.of();
        return new GroupingSetDescriptor(groupingKeys, 1, (Set<Integer>)globalGroupingSets);
    }

    public static GroupingSetDescriptor groupingSets(List<Symbol> groupingKeys, int groupingSetCount, Set<Integer> globalGroupingSets) {
        return new GroupingSetDescriptor(groupingKeys, groupingSetCount, globalGroupingSets);
    }

    public static Builder builderFrom(AggregationNode node) {
        return new Builder(node);
    }

    public static enum Step {
        PARTIAL(true, true),
        FINAL(false, false),
        INTERMEDIATE(false, true),
        SINGLE(true, false);

        private final boolean inputRaw;
        private final boolean outputPartial;

        private Step(boolean inputRaw, boolean outputPartial) {
            this.inputRaw = inputRaw;
            this.outputPartial = outputPartial;
        }

        public boolean isInputRaw() {
            return this.inputRaw;
        }

        public boolean isOutputPartial() {
            return this.outputPartial;
        }

        public static Step partialOutput(Step step) {
            if (step.isInputRaw()) {
                return PARTIAL;
            }
            return INTERMEDIATE;
        }

        public static Step partialInput(Step step) {
            if (step.isOutputPartial()) {
                return INTERMEDIATE;
            }
            return FINAL;
        }
    }

    public static class GroupingSetDescriptor {
        private final List<Symbol> groupingKeys;
        private final int groupingSetCount;
        private final Set<Integer> globalGroupingSets;

        @JsonCreator
        public GroupingSetDescriptor(@JsonProperty(value="groupingKeys") List<Symbol> groupingKeys, @JsonProperty(value="groupingSetCount") int groupingSetCount, @JsonProperty(value="globalGroupingSets") Set<Integer> globalGroupingSets) {
            Objects.requireNonNull(globalGroupingSets, "globalGroupingSets is null");
            Preconditions.checkArgument((groupingSetCount > 0 ? 1 : 0) != 0, (Object)"grouping set count must be larger than 0");
            Preconditions.checkArgument((globalGroupingSets.size() <= groupingSetCount ? 1 : 0) != 0, (Object)"list of empty global grouping sets must be no larger than grouping set count");
            Objects.requireNonNull(groupingKeys, "groupingKeys is null");
            if (groupingKeys.isEmpty()) {
                Preconditions.checkArgument((!globalGroupingSets.isEmpty() ? 1 : 0) != 0, (Object)"no grouping keys implies at least one global grouping set, but none provided");
            }
            this.groupingKeys = ImmutableList.copyOf(groupingKeys);
            this.groupingSetCount = groupingSetCount;
            this.globalGroupingSets = ImmutableSet.copyOf(globalGroupingSets);
        }

        @JsonProperty
        public List<Symbol> getGroupingKeys() {
            return this.groupingKeys;
        }

        @JsonProperty
        public int getGroupingSetCount() {
            return this.groupingSetCount;
        }

        @JsonProperty
        public Set<Integer> getGlobalGroupingSets() {
            return this.globalGroupingSets;
        }
    }

    public static class Builder {
        private PlanNodeId id;
        private PlanNode source;
        private Map<Symbol, Aggregation> aggregations;
        private GroupingSetDescriptor groupingSets;
        private List<Symbol> preGroupedSymbols;
        private Step step;
        private Optional<Symbol> hashSymbol;
        private Optional<Symbol> groupIdSymbol;

        public Builder(AggregationNode node) {
            Objects.requireNonNull(node, "node is null");
            this.id = node.getId();
            this.source = node.getSource();
            this.aggregations = node.getAggregations();
            this.groupingSets = node.getGroupingSets();
            this.preGroupedSymbols = node.getPreGroupedSymbols();
            this.step = node.getStep();
            this.hashSymbol = node.getHashSymbol();
            this.groupIdSymbol = node.getGroupIdSymbol();
        }

        public Builder setId(PlanNodeId id) {
            this.id = Objects.requireNonNull(id, "id is null");
            return this;
        }

        public Builder setSource(PlanNode source) {
            this.source = Objects.requireNonNull(source, "source is null");
            return this;
        }

        public Builder setAggregations(Map<Symbol, Aggregation> aggregations) {
            this.aggregations = Objects.requireNonNull(aggregations, "aggregations is null");
            return this;
        }

        public Builder setGroupingSets(GroupingSetDescriptor groupingSets) {
            this.groupingSets = Objects.requireNonNull(groupingSets, "groupingSets is null");
            return this;
        }

        public Builder setPreGroupedSymbols(List<Symbol> preGroupedSymbols) {
            this.preGroupedSymbols = Objects.requireNonNull(preGroupedSymbols, "preGroupedSymbols is null");
            return this;
        }

        public Builder setStep(Step step) {
            this.step = Objects.requireNonNull(step, "step is null");
            return this;
        }

        public Builder setHashSymbol(Optional<Symbol> hashSymbol) {
            this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
            return this;
        }

        public Builder setGroupIdSymbol(Optional<Symbol> groupIdSymbol) {
            this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol, "groupIdSymbol is null");
            return this;
        }

        public AggregationNode build() {
            return new AggregationNode(this.id, this.source, this.aggregations, this.groupingSets, this.preGroupedSymbols, this.step, this.hashSymbol, this.groupIdSymbol);
        }
    }

    public static class Aggregation {
        private final ResolvedFunction resolvedFunction;
        private final List<Expression> arguments;
        private final boolean distinct;
        private final Optional<Symbol> filter;
        private final Optional<OrderingScheme> orderingScheme;
        private final Optional<Symbol> mask;

        @JsonCreator
        public Aggregation(@JsonProperty(value="resolvedFunction") ResolvedFunction resolvedFunction, @JsonProperty(value="arguments") List<Expression> arguments, @JsonProperty(value="distinct") boolean distinct, @JsonProperty(value="filter") Optional<Symbol> filter, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme, @JsonProperty(value="mask") Optional<Symbol> mask) {
            this.resolvedFunction = Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
            this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
            for (Expression argument : arguments) {
                Preconditions.checkArgument((argument instanceof Reference || argument instanceof Lambda ? 1 : 0) != 0, (String)"argument must be symbol or lambda expression: %s", (Object)argument.getClass().getSimpleName());
            }
            this.distinct = distinct;
            this.filter = Objects.requireNonNull(filter, "filter is null");
            this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
            this.mask = Objects.requireNonNull(mask, "mask is null");
        }

        @JsonProperty
        public ResolvedFunction getResolvedFunction() {
            return this.resolvedFunction;
        }

        @JsonProperty
        public List<Expression> getArguments() {
            return this.arguments;
        }

        @JsonProperty
        public boolean isDistinct() {
            return this.distinct;
        }

        @JsonProperty
        public Optional<Symbol> getFilter() {
            return this.filter;
        }

        @JsonProperty
        public Optional<OrderingScheme> getOrderingScheme() {
            return this.orderingScheme;
        }

        @JsonProperty
        public Optional<Symbol> getMask() {
            return this.mask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Aggregation that = (Aggregation)o;
            return this.distinct == that.distinct && Objects.equals(this.resolvedFunction, that.resolvedFunction) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.filter, that.filter) && Objects.equals(this.orderingScheme, that.orderingScheme) && Objects.equals(this.mask, that.mask);
        }

        public int hashCode() {
            return Objects.hash(this.resolvedFunction, this.arguments, this.distinct, this.filter, this.orderingScheme, this.mask);
        }

        private void verifyArguments(Step step) {
            int expectedArgumentCount = step == Step.SINGLE || step == Step.PARTIAL ? this.resolvedFunction.signature().getArgumentTypes().size() : 1 + (int)this.resolvedFunction.signature().getArgumentTypes().stream().filter(FunctionType.class::isInstance).count();
            Preconditions.checkArgument((expectedArgumentCount == this.arguments.size() ? 1 : 0) != 0, (String)"%s aggregation function %s has %s arguments, but %s arguments were provided to function call", (Object)((Object)step), (Object)this.resolvedFunction.signature(), (Object)expectedArgumentCount, (Object)this.arguments.size());
        }
    }
}

