/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.secrets.SecretsResolver;
import io.airlift.testing.TempFile;
import io.trino.connector.CatalogStoreConfig;
import io.trino.connector.CatalogStoreManager;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.catalog.CatalogProperties;
import io.trino.spi.catalog.CatalogStore;
import io.trino.spi.catalog.CatalogStoreFactory;
import io.trino.spi.connector.ConnectorName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestCatalogStoreManager {
    TestCatalogStoreManager() {
    }

    @Test
    void testCatalogStoreIsLoaded() throws IOException {
        try (TempFile tempFile = new TempFile();){
            Files.writeString(tempFile.path(), (CharSequence)"some-property=some-value", new OpenOption[0]);
            CatalogStoreConfig catalogStoreConfig = new CatalogStoreConfig().setCatalogStoreKind("test");
            CatalogStoreManager catalogStoreManager = new CatalogStoreManager(new SecretsResolver((Map)ImmutableMap.of()), catalogStoreConfig);
            catalogStoreManager.addCatalogStoreFactory((CatalogStoreFactory)new TestingCatalogStoreFactory());
            catalogStoreManager.loadConfiguredCatalogStore(catalogStoreConfig.getCatalogStoreKind(), tempFile.file());
            Assertions.assertThat((Collection)catalogStoreManager.getCatalogs()).containsExactly((Object[])new CatalogStore.StoredCatalog[]{TestingCatalogStore.STORED_CATALOG});
        }
    }

    @Test
    void testCatalogStoreIsLoadedWithoutConfiguration() throws IOException {
        CatalogStoreManager catalogStoreManager = new CatalogStoreManager(new SecretsResolver((Map)ImmutableMap.of()), new CatalogStoreConfig().setCatalogStoreKind("test"));
        catalogStoreManager.addCatalogStoreFactory((CatalogStoreFactory)new TestingCatalogStoreFactory());
        catalogStoreManager.loadConfiguredCatalogStore();
        Assertions.assertThat((Collection)catalogStoreManager.getCatalogs()).containsExactly((Object[])new CatalogStore.StoredCatalog[]{TestingCatalogStore.STORED_CATALOG});
    }

    private static class TestingCatalogStoreFactory
    implements CatalogStoreFactory {
        private TestingCatalogStoreFactory() {
        }

        public String getName() {
            return "test";
        }

        public CatalogStore create(Map<String, String> config) {
            return new TestingCatalogStore();
        }
    }

    private static final class TestingCatalogStore
    implements CatalogStore {
        private static final CatalogStore.StoredCatalog STORED_CATALOG = new CatalogStore.StoredCatalog(){

            public CatalogName name() {
                throw new UnsupportedOperationException();
            }

            public CatalogProperties loadProperties() {
                throw new UnsupportedOperationException();
            }
        };

        private TestingCatalogStore() {
        }

        public Collection<CatalogStore.StoredCatalog> getCatalogs() {
            return ImmutableList.of((Object)STORED_CATALOG);
        }

        public CatalogProperties createCatalogProperties(CatalogName catalogName, ConnectorName connectorName, Map<String, String> properties) {
            throw new UnsupportedOperationException();
        }

        public void addOrReplaceCatalog(CatalogProperties catalogProperties) {
            throw new UnsupportedOperationException();
        }

        public void removeCatalog(CatalogName catalogName) {
            throw new UnsupportedOperationException();
        }
    }
}

