/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestNodeSchedulerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeSchedulerConfig)ConfigAssertions.recordDefaults(NodeSchedulerConfig.class)).setNodeSchedulerPolicy(NodeSchedulerConfig.NodeSchedulerPolicy.UNIFORM.name()).setMinCandidates(10).setMaxSplitsPerNode(256).setMinPendingSplitsPerTask(16).setMaxAdjustedPendingSplitsWeightPerTask(2000).setMaxUnacknowledgedSplitsPerTask(2000).setIncludeCoordinator(true).setSplitsBalancingPolicy(NodeSchedulerConfig.SplitsBalancingPolicy.STAGE).setOptimizedLocalScheduling(true).setAllowedNoMatchingNodePeriod(new Duration(2.0, TimeUnit.MINUTES)).setExhaustedNodeWaitPeriod(new Duration(2.0, TimeUnit.MINUTES)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"node-scheduler.policy", (Object)"topology").put((Object)"node-scheduler.min-candidates", (Object)"11").put((Object)"node-scheduler.include-coordinator", (Object)"false").put((Object)"node-scheduler.min-pending-splits-per-task", (Object)"11").put((Object)"node-scheduler.max-adjusted-pending-splits-per-task", (Object)"33").put((Object)"node-scheduler.max-splits-per-node", (Object)"101").put((Object)"node-scheduler.max-unacknowledged-splits-per-task", (Object)"501").put((Object)"node-scheduler.splits-balancing-policy", (Object)"node").put((Object)"node-scheduler.optimized-local-scheduling", (Object)"false").put((Object)"node-scheduler.allowed-no-matching-node-period", (Object)"1m").put((Object)"node-scheduler.exhausted-node-wait-period", (Object)"3m").buildOrThrow();
        NodeSchedulerConfig expected = new NodeSchedulerConfig().setNodeSchedulerPolicy("topology").setIncludeCoordinator(false).setMaxSplitsPerNode(101).setMinPendingSplitsPerTask(11).setMaxAdjustedPendingSplitsWeightPerTask(33).setMaxUnacknowledgedSplitsPerTask(501).setMinCandidates(11).setSplitsBalancingPolicy(NodeSchedulerConfig.SplitsBalancingPolicy.NODE).setOptimizedLocalScheduling(false).setAllowedNoMatchingNodePeriod(new Duration(1.0, TimeUnit.MINUTES)).setExhaustedNodeWaitPeriod(new Duration(3.0, TimeUnit.MINUTES));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

