/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.SequencePageBuilder;
import io.trino.SessionTestUtils;
import io.trino.execution.buffer.PageSplitterUtil;
import io.trino.operator.OperatorAssertion;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedResult;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPageSplitterUtil {
    @Test
    public void testSplitPage() {
        int positionCount = 10;
        int maxPageSizeInBytes = 100;
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        Page largePage = SequencePageBuilder.createSequencePage((List<? extends Type>)types, positionCount, 0, 1, 1);
        List pages = PageSplitterUtil.splitPage((Page)largePage, (long)maxPageSizeInBytes);
        Assertions.assertThat((List)pages).hasSizeGreaterThan(1);
        TestPageSplitterUtil.assertPageSize(pages, maxPageSizeInBytes);
        TestPageSplitterUtil.assertPositionCount(pages, positionCount);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, pages);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, (List<Page>)ImmutableList.of((Object)largePage));
        Assertions.assertThat((Iterable)actual).containsExactlyElementsOf((Iterable)expected);
    }

    private static void assertPageSize(List<Page> pages, long maxPageSizeInBytes) {
        for (Page page : pages) {
            Assertions.assertThat((long)page.getSizeInBytes()).isLessThanOrEqualTo(maxPageSizeInBytes);
        }
    }

    private static void assertPositionCount(List<Page> pages, int positionCount) {
        int totalPositionCount = 0;
        for (Page page : pages) {
            totalPositionCount += page.getPositionCount();
        }
        Assertions.assertThat((int)totalPositionCount).isEqualTo(positionCount);
    }

    @Test
    public void testSplitPageNonDecreasingPageSize() {
        int positionCount = 100;
        int maxPageSizeInBytes = 1;
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        Slice expectedValue = Slices.wrappedBuffer((byte[])"test".getBytes(StandardCharsets.UTF_8));
        VariableWidthBlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1, expectedValue.length());
        blockBuilder.writeEntry(expectedValue);
        Block rleBlock = RunLengthEncodedBlock.create((Block)blockBuilder.build(), (int)positionCount);
        Page initialPage = new Page(new Block[]{rleBlock});
        List pages = PageSplitterUtil.splitPage((Page)initialPage, (long)maxPageSizeInBytes);
        Assertions.assertThat((int)pages.size()).isEqualTo(2);
        Page first = (Page)pages.get(0);
        Page second = (Page)pages.get(1);
        Assertions.assertThat((int)((int)first.getSizeInBytes())).isGreaterThan(maxPageSizeInBytes);
        Assertions.assertThat((int)((int)second.getSizeInBytes())).isGreaterThan(maxPageSizeInBytes);
        TestPageSplitterUtil.assertPositionCount(pages, positionCount);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, pages);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, (List<Type>)types, (List<Page>)ImmutableList.of((Object)initialPage));
        Assertions.assertThat((Iterable)actual).containsExactlyElementsOf((Iterable)expected);
    }
}

