/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.SetPathTask;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.TestMetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PathElement;
import io.trino.sql.tree.PathSpecification;
import io.trino.sql.tree.SetPath;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSetPathTask {
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private Metadata metadata;
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @BeforeAll
    public void setUp() {
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        this.accessControl = new AllowAllAccessControl();
        this.metadata = TestMetadataManager.builder().withTransactionManager(this.transactionManager).build();
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.transactionManager = null;
        this.accessControl = null;
        this.metadata = null;
    }

    @Test
    public void testSetPath() {
        PathSpecification pathSpecification = new PathSpecification(new NodeLocation(1, 10), (List)ImmutableList.of((Object)new PathElement(new NodeLocation(1, 1), Optional.empty(), new Identifier("foo"))));
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET PATH foo");
        this.executeSetPathTask(pathSpecification, stateMachine);
        Assertions.assertThat((String)stateMachine.getSetPath()).isEqualTo("foo");
    }

    @Test
    public void testSetPathInvalidCatalog() {
        PathSpecification invalidPathSpecification = new PathSpecification(new NodeLocation(1, 10), (List)ImmutableList.of((Object)new PathElement(new NodeLocation(1, 1), Optional.of(new Identifier("invalidCatalog")), new Identifier("thisDoesNotMatter"))));
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET PATH invalidCatalog.thisDoesNotMatter");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeSetPathTask(invalidPathSpecification, stateMachine)).isInstanceOf(TrinoException.class)).hasMessageMatching(".* Catalog '.*' not found");
    }

    private QueryStateMachine createQueryStateMachine(String query) {
        return QueryStateMachine.begin(Optional.empty(), (String)query, Optional.empty(), (Session)TestingSession.testSession(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, (NodeVersion)new NodeVersion("test"));
    }

    private void executeSetPathTask(PathSpecification pathSpecification, QueryStateMachine stateMachine) {
        MoreFutures.getFutureValue((Future)new SetPathTask(this.metadata).execute(new SetPath(new NodeLocation(1, 1), pathSpecification), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
    }
}

