/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.execution.FailureInjector;
import io.trino.execution.TestingFailureInjectionConfig;
import io.trino.spi.ErrorType;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class TestingFailureInjector
implements FailureInjector {
    private final NonEvictableCache<Key, FailureInjector.InjectedFailure> failures;
    private final Duration requestTimeout;

    @Inject
    public TestingFailureInjector(TestingFailureInjectionConfig config) {
        this(config.getExpirationPeriod(), config.getRequestTimeout());
    }

    public TestingFailureInjector(Duration expirationPeriod, Duration requestTimeout) {
        this.failures = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().expireAfterWrite(expirationPeriod.toMillis(), TimeUnit.MILLISECONDS));
        this.requestTimeout = Objects.requireNonNull(requestTimeout, "requestTimeout is null");
    }

    public void injectTaskFailure(String traceToken, int stageId, int partitionId, int attemptId, FailureInjector.InjectedFailureType injectionType, Optional<ErrorType> errorType) {
        this.failures.put((Object)new Key(traceToken, stageId, partitionId, attemptId), (Object)new FailureInjector.InjectedFailure(injectionType, errorType));
    }

    public Optional<FailureInjector.InjectedFailure> getInjectedFailure(String traceToken, int stageId, int partitionId, int attemptId) {
        if (this.failures.size() == 0L) {
            return Optional.empty();
        }
        return Optional.ofNullable((FailureInjector.InjectedFailure)this.failures.getIfPresent((Object)new Key(traceToken, stageId, partitionId, attemptId)));
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    private static class Key {
        private final String traceToken;
        private final int stageId;
        private final int partitionId;
        private final int attemptId;

        private Key(String traceToken, int stageId, int partitionId, int attemptId) {
            this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
            this.stageId = stageId;
            this.partitionId = partitionId;
            this.attemptId = attemptId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.stageId == key.stageId && this.partitionId == key.partitionId && this.attemptId == key.attemptId && Objects.equals(this.traceToken, key.traceToken);
        }

        public int hashCode() {
            return Objects.hash(this.traceToken, this.stageId, this.partitionId, this.attemptId);
        }
    }
}

