/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.SplitAssigner;
import io.trino.execution.scheduler.faulttolerant.SplitsMapping;
import io.trino.execution.scheduler.faulttolerant.TaskDescriptor;
import io.trino.execution.scheduler.faulttolerant.TestingConnectorSplit;
import io.trino.metadata.Split;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;

class SplitAssignerTester {
    private final Map<Integer, NodeRequirements> nodeRequirements = new HashMap<Integer, NodeRequirements>();
    private final Map<Integer, SplitsMapping> splits = new HashMap<Integer, SplitsMapping>();
    private final SetMultimap<Integer, PlanNodeId> noMoreSplits = HashMultimap.create();
    private final Set<Integer> sealedTaskPartitions = new HashSet<Integer>();
    private boolean noMoreTaskPartitions;
    private Optional<List<TaskDescriptor>> taskDescriptors = Optional.empty();

    SplitAssignerTester() {
    }

    public Optional<List<TaskDescriptor>> getTaskDescriptors() {
        return this.taskDescriptors;
    }

    public synchronized int getTaskPartitionCount() {
        return this.nodeRequirements.size();
    }

    public synchronized NodeRequirements getNodeRequirements(int taskPartition) {
        NodeRequirements result = this.nodeRequirements.get(taskPartition);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"task partition not found: %s", (int)taskPartition);
        return result;
    }

    public synchronized Set<Integer> getSplitIds(int taskPartition, PlanNodeId planNodeId) {
        SplitsMapping taskPartitionSplits = this.splits.getOrDefault(taskPartition, SplitsMapping.EMPTY);
        List splitsFlat = taskPartitionSplits.getSplitsFlat(planNodeId);
        return (Set)splitsFlat.stream().map(split -> (TestingConnectorSplit)split.getConnectorSplit()).map(TestingConnectorSplit::getId).collect(ImmutableSet.toImmutableSet());
    }

    public synchronized ListMultimap<Integer, Integer> getSplitIdsBySourcePartition(int taskPartition, PlanNodeId planNodeId) {
        SplitsMapping taskPartitionSplits = this.splits.getOrDefault(taskPartition, SplitsMapping.EMPTY);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        taskPartitionSplits.getSplits(planNodeId).forEach((sourcePartition, split) -> builder.put(sourcePartition, (Object)TestingConnectorSplit.getSplitId(split)));
        return builder.build();
    }

    public synchronized boolean isNoMoreSplits(int taskPartition, PlanNodeId planNodeId) {
        return this.noMoreSplits.get((Object)taskPartition).contains(planNodeId);
    }

    public synchronized boolean isSealed(int taskPartition) {
        return this.sealedTaskPartitions.contains(taskPartition);
    }

    public synchronized boolean isNoMoreTaskPartitions() {
        return this.noMoreTaskPartitions;
    }

    public void checkContainsSplits(PlanNodeId planNodeId, Collection<Split> splits, boolean replicated) {
        Set expectedSplitIds = splits.stream().map(TestingConnectorSplit::getSplitId).collect(Collectors.toSet());
        for (int taskPartitionId = 0; taskPartitionId < this.getTaskPartitionCount(); ++taskPartitionId) {
            Set<Integer> taskPartitionSplitIds = this.getSplitIds(taskPartitionId, planNodeId);
            if (replicated) {
                Assertions.assertThat(taskPartitionSplitIds).containsAll(expectedSplitIds);
                continue;
            }
            expectedSplitIds.removeAll(taskPartitionSplitIds);
        }
        if (!replicated) {
            Assertions.assertThat(expectedSplitIds).isEmpty();
        }
    }

    public void checkContainsSplits(PlanNodeId planNodeId, ListMultimap<Integer, Split> splitsBySourcePartition, boolean replicated) {
        ArrayListMultimap expectedSplitIds;
        if (replicated) {
            expectedSplitIds = ArrayListMultimap.create();
            expectedSplitIds.putAll((Object)0, (Iterable)this.buildSplitIds(splitsBySourcePartition).values());
        } else {
            expectedSplitIds = ArrayListMultimap.create(this.buildSplitIds(splitsBySourcePartition));
        }
        for (int taskPartitionId = 0; taskPartitionId < this.getTaskPartitionCount(); ++taskPartitionId) {
            ListMultimap<Integer, Integer> taskPartitionSplitIds = this.getSplitIdsBySourcePartition(taskPartitionId, planNodeId);
            if (replicated) {
                org.assertj.guava.api.Assertions.assertThat(taskPartitionSplitIds).containsAllEntriesOf((Multimap)expectedSplitIds);
                continue;
            }
            taskPartitionSplitIds.forEach((arg_0, arg_1) -> ((ListMultimap)expectedSplitIds).remove(arg_0, arg_1));
        }
        if (!replicated) {
            org.assertj.guava.api.Assertions.assertThat((Multimap)expectedSplitIds).isEmpty();
        }
    }

    private ListMultimap<Integer, Integer> buildSplitIds(ListMultimap<Integer, Split> splitsBySourcePartition) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        splitsBySourcePartition.forEach((sourcePartition, split) -> builder.put(sourcePartition, (Object)TestingConnectorSplit.getSplitId(split)));
        return builder.build();
    }

    public void update(SplitAssigner.AssignmentResult assignment) {
        for (SplitAssigner.Partition taskPartition : assignment.partitionsAdded()) {
            Verify.verify((!this.noMoreTaskPartitions ? 1 : 0) != 0, (String)"noMoreTaskPartitions is set", (Object[])new Object[0]);
            Verify.verify((this.nodeRequirements.put(taskPartition.partitionId(), taskPartition.nodeRequirements()) == null ? 1 : 0) != 0, (String)"task partition already exist: %s", (int)taskPartition.partitionId());
        }
        for (SplitAssigner.PartitionUpdate taskPartitionUpdate : assignment.partitionUpdates()) {
            int taskPartitionId = taskPartitionUpdate.partitionId();
            Verify.verify((this.nodeRequirements.get(taskPartitionId) != null ? 1 : 0) != 0, (String)"task partition does not exist: %s", (int)taskPartitionId);
            Verify.verify((!this.sealedTaskPartitions.contains(taskPartitionId) ? 1 : 0) != 0, (String)"task partition is sealed: %s", (int)taskPartitionId);
            PlanNodeId planNodeId = taskPartitionUpdate.planNodeId();
            if (!taskPartitionUpdate.splits().isEmpty()) {
                Verify.verify((!this.noMoreSplits.get((Object)taskPartitionId).contains(planNodeId) ? 1 : 0) != 0, (String)"noMoreSplits is set for task partition %s and plan node %s", (int)taskPartitionId, (Object)planNodeId);
                this.splits.merge(taskPartitionId, SplitsMapping.builder().addSplits(planNodeId, taskPartitionUpdate.splits()).build(), (originalMapping, updatedMapping) -> SplitsMapping.builder((SplitsMapping)originalMapping).addMapping(updatedMapping).build());
            }
            if (!taskPartitionUpdate.noMoreSplits()) continue;
            this.noMoreSplits.put((Object)taskPartitionId, (Object)planNodeId);
        }
        assignment.sealedPartitions().forEach(this.sealedTaskPartitions::add);
        if (assignment.noMorePartitions()) {
            this.noMoreTaskPartitions = true;
        }
        this.checkFinished();
    }

    private synchronized void checkFinished() {
        if (this.noMoreTaskPartitions && this.sealedTaskPartitions.containsAll(this.nodeRequirements.keySet())) {
            Verify.verify((boolean)this.sealedTaskPartitions.equals(this.nodeRequirements.keySet()), (String)"unknown sealed partitions: %s", (Object)Sets.difference(this.sealedTaskPartitions, this.nodeRequirements.keySet()));
            ImmutableList.Builder result = ImmutableList.builder();
            for (Integer taskPartitionId : this.sealedTaskPartitions) {
                SplitsMapping taskSplits = this.splits.getOrDefault(taskPartitionId, SplitsMapping.EMPTY);
                Verify.verify((boolean)this.noMoreSplits.get((Object)taskPartitionId).containsAll(taskSplits.getPlanNodeIds()), (String)"no more split is missing for task partition %s: %s", (Object)taskPartitionId, (Object)Sets.difference((Set)taskSplits.getPlanNodeIds(), (Set)this.noMoreSplits.get((Object)taskPartitionId)));
                result.add((Object)new TaskDescriptor(taskPartitionId.intValue(), taskSplits, this.nodeRequirements.get(taskPartitionId)));
            }
            this.taskDescriptors = Optional.of(result.build());
        }
    }
}

