/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.warnings;

import io.trino.execution.warnings.DefaultWarningCollector;
import io.trino.execution.warnings.WarningCollectorConfig;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCode;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDefaultWarningCollector {
    @Test
    public void testNoWarnings() {
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig().setMaxWarnings(0));
        warningCollector.add(new TrinoWarning(new WarningCode(1, "1"), "warning 1"));
        Assertions.assertThat((int)warningCollector.getWarnings().size()).isEqualTo(0);
    }

    @Test
    public void testMaxWarnings() {
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig().setMaxWarnings(2));
        warningCollector.add(new TrinoWarning(new WarningCode(1, "1"), "warning 1"));
        warningCollector.add(new TrinoWarning(new WarningCode(2, "2"), "warning 2"));
        warningCollector.add(new TrinoWarning(new WarningCode(3, "3"), "warning 3"));
        Assertions.assertThat((int)warningCollector.getWarnings().size()).isEqualTo(2);
    }
}

