/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.memory.NodeMemoryConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestNodeMemoryConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeMemoryConfig)ConfigAssertions.recordDefaults(NodeMemoryConfig.class)).setMaxQueryMemoryPerNode(DataSize.ofBytes((long)Math.round((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3))).setHeapHeadroom(DataSize.ofBytes((long)Math.round((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3))));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"query.max-memory-per-node", (Object)"1GB").put((Object)"memory.heap-headroom-per-node", (Object)"1GB").buildOrThrow();
        NodeMemoryConfig expected = new NodeMemoryConfig().setMaxQueryMemoryPerNode(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setHeapHeadroom(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

