/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.airlift.slice.SizeOf;
import io.trino.operator.CompletedWork;
import io.trino.operator.GroupByHash;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;

public class CyclingGroupByHash
implements GroupByHash {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(CyclingGroupByHash.class);
    private final int totalGroupCount;
    private int maxGroupId;
    private int currentGroupId;

    public CyclingGroupByHash(int totalGroupCount) {
        this.totalGroupCount = totalGroupCount;
    }

    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    public int getGroupCount() {
        return this.maxGroupId + 1;
    }

    public void appendValuesTo(int groupId, PageBuilder pageBuilder) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public Work<?> addPage(Page page) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public Work<int[]> getGroupIds(Page page) {
        int[] groupIds = new int[page.getPositionCount()];
        for (int i = 0; i < page.getPositionCount(); ++i) {
            groupIds[i] = this.currentGroupId;
            this.maxGroupId = Math.max(this.currentGroupId, this.maxGroupId);
            this.currentGroupId = (this.currentGroupId + 1) % this.totalGroupCount;
        }
        return new CompletedWork((Object)groupIds);
    }

    public long getRawHash(int groupId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public int getCapacity() {
        return this.totalGroupCount;
    }
}

