/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.util.concurrent.SettableFuture;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

public final class WorkProcessorAssertion {
    private WorkProcessorAssertion() {
    }

    public static <T> void assertBlocks(WorkProcessor<T> processor) {
        Assertions.assertThat((boolean)processor.process()).isFalse();
        Assertions.assertThat((boolean)processor.isBlocked()).isTrue();
        Assertions.assertThat((boolean)processor.isFinished()).isFalse();
        Assertions.assertThat((boolean)processor.process()).isFalse();
    }

    public static <T, V> void assertUnblocks(WorkProcessor<T> processor, SettableFuture<V> future) {
        future.set(null);
        Assertions.assertThat((boolean)processor.isBlocked()).isFalse();
    }

    public static <T> void assertYields(WorkProcessor<T> processor) {
        Assertions.assertThat((boolean)processor.process()).isFalse();
        Assertions.assertThat((boolean)processor.isBlocked()).isFalse();
        Assertions.assertThat((boolean)processor.isFinished()).isFalse();
    }

    public static <T> void assertResult(WorkProcessor<T> processor, T result) {
        WorkProcessorAssertion.validateResult(processor, actualResult -> Assertions.assertThat((Object)processor.getResult()).isEqualTo(result));
    }

    public static <T> void validateResult(WorkProcessor<T> processor, Consumer<T> validator) {
        Assertions.assertThat((boolean)processor.process()).isTrue();
        Assertions.assertThat((boolean)processor.isBlocked()).isFalse();
        Assertions.assertThat((boolean)processor.isFinished()).isFalse();
        validator.accept(processor.getResult());
    }

    public static <T> void assertFinishes(WorkProcessor<T> processor) {
        Assertions.assertThat((boolean)processor.process()).isTrue();
        Assertions.assertThat((boolean)processor.isBlocked()).isFalse();
        Assertions.assertThat((boolean)processor.isFinished()).isTrue();
        Assertions.assertThat((boolean)processor.process()).isTrue();
    }

    public static <T, R> WorkProcessor.Transformation<T, R> transformationFrom(List<Transform<T, R>> transformations) {
        return WorkProcessorAssertion.transformationFrom(transformations, Objects::equals);
    }

    public static <T, R> WorkProcessor.Transformation<T, R> transformationFrom(List<Transform<T, R>> transformations, BiPredicate<T, T> equalsPredicate) {
        Iterator iterator = transformations.iterator();
        return element -> {
            Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
            return ((Transform)iterator.next()).transform(Optional.ofNullable(element), (left, right) -> left.isPresent() == right.isPresent() && (left.isEmpty() || equalsPredicate.test(left.get(), right.get())));
        };
    }

    public static <T> WorkProcessor<T> processorFrom(List<WorkProcessor.ProcessState<T>> states) {
        Iterator iterator = states.iterator();
        return WorkProcessorUtils.create(() -> {
            Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
            return (WorkProcessor.ProcessState)iterator.next();
        });
    }

    public static class Transform<T, R> {
        private final Optional<T> from;
        private final WorkProcessor.TransformationState<R> to;

        public static <T, R> Transform<T, R> of(Optional<T> from, WorkProcessor.TransformationState<R> to) {
            return new Transform<T, R>(from, to);
        }

        private Transform(Optional<T> from, WorkProcessor.TransformationState<R> to) {
            this.from = Objects.requireNonNull(from);
            this.to = Objects.requireNonNull(to);
        }

        private WorkProcessor.TransformationState<R> transform(Optional<T> from, BiPredicate<Optional<T>, Optional<T>> equalsPredicate) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)equalsPredicate.test(from, this.from)).describedAs(String.format("Expected %s to be equal to %s", from, this.from), new Object[0])).isTrue();
            return this.to;
        }
    }
}

