/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AggregationLoopBuilder;
import io.trino.operator.aggregation.AggregationMask;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestAggregationLoopBuilder {
    private static final MethodHandle INPUT_FUNCTION;
    private static final Object LAMBDA_A;
    private static final Object LAMBDA_B;
    private MethodHandle loop;
    private List<TestParameter> keyBlocks;
    private List<TestParameter> valueBlocks;

    @BeforeAll
    public void setUp() throws ReflectiveOperationException {
        this.loop = AggregationLoopBuilder.buildLoop((MethodHandle)INPUT_FUNCTION, (int)1, (int)2, (boolean)false);
        IntArrayBlock keyBasic = new IntArrayBlock(5, Optional.empty(), new int[]{10, 11, 12, 13, 14});
        IntArrayBlock keyRleValue = new IntArrayBlock(1, Optional.empty(), new int[]{33});
        IntArrayBlock keyDictionary = new IntArrayBlock(3, Optional.empty(), new int[]{55, 54, 53});
        this.keyBlocks = ImmutableList.builder().add((Object)new TestParameter((Block)keyBasic, (ValueBlock)keyBasic, new int[]{0, 1, 2, 3, 4})).add((Object)new TestParameter(RunLengthEncodedBlock.create((Block)keyRleValue, (int)5), (ValueBlock)keyRleValue, new int[]{0, 0, 0, 0, 0})).add((Object)new TestParameter(DictionaryBlock.create((int)7, (Block)keyDictionary, (int[])new int[]{9, 9, 2, 1, 0, 1, 2}).getRegion(2, 5), (ValueBlock)keyDictionary, new int[]{2, 1, 0, 1, 2})).build();
        IntArrayBlock valueBasic = new IntArrayBlock(5, Optional.empty(), new int[]{10, 11, 12, 13, 14});
        IntArrayBlock valueRleValue = new IntArrayBlock(1, Optional.empty(), new int[]{44});
        IntArrayBlock valueDictionary = new IntArrayBlock(3, Optional.empty(), new int[]{66, 65, 64});
        this.valueBlocks = ImmutableList.builder().add((Object)new TestParameter((Block)valueBasic, (ValueBlock)valueBasic, new int[]{0, 1, 2, 3, 4})).add((Object)new TestParameter(RunLengthEncodedBlock.create((Block)valueRleValue, (int)5), (ValueBlock)valueRleValue, new int[]{0, 0, 0, 0, 0})).add((Object)new TestParameter(DictionaryBlock.create((int)7, (Block)valueDictionary, (int[])new int[]{9, 9, 0, 1, 2, 1, 0}).getRegion(2, 5), (ValueBlock)valueDictionary, new int[]{0, 1, 2, 1, 0})).build();
    }

    @Test
    public void testSelectAll() throws Throwable {
        AggregationMask mask = AggregationMask.createSelectAll((int)5);
        for (TestParameter keyBlock : this.keyBlocks) {
            for (TestParameter valueBlock : this.valueBlocks) {
                InvocationList invocationList = new InvocationList();
                this.loop.invokeExact(mask, invocationList, keyBlock.inputBlock(), valueBlock.inputBlock(), LAMBDA_A, LAMBDA_B);
                Assertions.assertThat(invocationList.getInvocations()).isEqualTo(TestAggregationLoopBuilder.buildExpectedInvocation(keyBlock, valueBlock, mask).getInvocations());
            }
        }
    }

    @Test
    public void testMasked() throws Throwable {
        AggregationMask mask = AggregationMask.createSelectedPositions((int)5, (int[])new int[]{1, 2, 4}, (int)3);
        for (TestParameter keyBlock : this.keyBlocks) {
            for (TestParameter valueBlock : this.valueBlocks) {
                InvocationList invocationList = new InvocationList();
                this.loop.invokeExact(mask, invocationList, keyBlock.inputBlock(), valueBlock.inputBlock(), LAMBDA_A, LAMBDA_B);
                Assertions.assertThat(invocationList.getInvocations()).isEqualTo(TestAggregationLoopBuilder.buildExpectedInvocation(keyBlock, valueBlock, mask).getInvocations());
            }
        }
    }

    private static InvocationList buildExpectedInvocation(TestParameter keyBlock, TestParameter valueBlock, AggregationMask mask) {
        InvocationList invocationList = new InvocationList();
        int[] keyPositions = keyBlock.invokedPositions();
        int[] valuePositions = valueBlock.invokedPositions();
        if (mask.isSelectAll()) {
            for (int position = 0; position < keyPositions.length; ++position) {
                invocationList.add(keyBlock.invokedBlock(), keyPositions[position], valueBlock.invokedBlock(), valuePositions[position], LAMBDA_A, LAMBDA_B);
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < mask.getSelectedPositionCount(); ++i) {
                int position = selectedPositions[i];
                invocationList.add(keyBlock.invokedBlock(), keyPositions[position], valueBlock.invokedBlock(), valuePositions[position], LAMBDA_A, LAMBDA_B);
            }
        }
        return invocationList;
    }

    public static void input(@AggregationState InvocationList invocationList, @BlockPosition @SqlType(value="K") ValueBlock keyBlock, @BlockIndex int keyPosition, @SqlNullable @BlockPosition @SqlType(value="V") ValueBlock valueBlock, @BlockIndex int valuePosition, Object lambdaA, Object lambdaB) {
        invocationList.add(keyBlock, keyPosition, valueBlock, valuePosition, lambdaA, lambdaB);
    }

    static {
        LAMBDA_A = "lambda a";
        LAMBDA_B = 1234L;
        try {
            INPUT_FUNCTION = MethodHandles.lookup().findStatic(TestAggregationLoopBuilder.class, "input", MethodType.methodType(Void.TYPE, InvocationList.class, ValueBlock.class, Integer.TYPE, ValueBlock.class, Integer.TYPE, Object.class, Object.class));
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private record TestParameter(Block inputBlock, ValueBlock invokedBlock, int[] invokedPositions) {
    }

    public static class InvocationList {
        private final List<Invocation> invocations = new ArrayList<Invocation>();

        public void add(ValueBlock keyBlock, int keyPosition, ValueBlock valueBlock, int valuePosition, Object lambdaA, Object lambdaB) {
            this.invocations.add(new Invocation(keyBlock, keyPosition, valueBlock, valuePosition, lambdaA, lambdaB));
        }

        public List<Invocation> getInvocations() {
            return ImmutableList.copyOf(this.invocations);
        }

        public record Invocation(ValueBlock keyBlock, int keyPosition, ValueBlock valueBlock, int valuePosition, Object lambdaA, Object lambdaB) {
        }
    }
}

