/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.SqlIntervalDayTime;
import java.util.List;

public class TestIntervalDayToSecondAverageAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = IntervalDayTimeType.INTERVAL_DAY_TIME.createFixedSizeBlockBuilder(length);
        for (int i = start; i < start + length; ++i) {
            IntervalDayTimeType.INTERVAL_DAY_TIME.writeLong(blockBuilder, (long)i * 250L);
        }
        return new Block[]{blockBuilder.build()};
    }

    protected SqlIntervalDayTime getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        double sum = 0.0;
        for (int i = start; i < start + length; ++i) {
            sum += (double)(i * 250);
        }
        return new SqlIntervalDayTime(Math.round(sum / (double)length));
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)IntervalDayTimeType.INTERVAL_DAY_TIME);
    }
}

