/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.array.BooleanBigArray;
import io.trino.array.DoubleBigArray;
import io.trino.array.LongBigArray;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.state.LongState;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.operator.aggregation.state.VarianceState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.InOut;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStateCompiler {
    @Test
    public void testPrimitiveNullableLongSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(NullableLongState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(NullableLongState.class);
        NullableLongState state = (NullableLongState)factory.createSingleState();
        NullableLongState deserializedState = (NullableLongState)factory.createSingleState();
        state.setValue(2L);
        state.setNull(false);
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(2);
        serializer.serialize((AccumulatorState)state, builder);
        state.setNull(true);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        Assertions.assertThat((boolean)block.isNull(0)).isFalse();
        Assertions.assertThat((long)BigintType.BIGINT.getLong(block, 0)).isEqualTo(state.getValue());
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assertions.assertThat((long)deserializedState.getValue()).isEqualTo(state.getValue());
        Assertions.assertThat((boolean)block.isNull(1)).isTrue();
    }

    @Test
    public void testPrimitiveLongSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(LongState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(LongState.class);
        LongState state = (LongState)factory.createSingleState();
        LongState deserializedState = (LongState)factory.createSingleState();
        state.setValue(2L);
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(1);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        Assertions.assertThat((long)BigintType.BIGINT.getLong(block, 0)).isEqualTo(state.getValue());
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assertions.assertThat((long)deserializedState.getValue()).isEqualTo(state.getValue());
    }

    @Test
    public void testGetSerializedType() {
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(LongState.class);
        Assertions.assertThat((Object)serializer.getSerializedType()).isEqualTo((Object)BigintType.BIGINT);
    }

    @Test
    public void testPrimitiveBooleanSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(BooleanState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(BooleanState.class);
        BooleanState state = (BooleanState)factory.createSingleState();
        BooleanState deserializedState = (BooleanState)factory.createSingleState();
        state.setBoolean(true);
        BlockBuilder builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(1);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assertions.assertThat((boolean)deserializedState.isBoolean()).isEqualTo(state.isBoolean());
    }

    @Test
    public void testPrimitiveByteSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(ByteState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(ByteState.class);
        ByteState state = (ByteState)factory.createSingleState();
        ByteState deserializedState = (ByteState)factory.createSingleState();
        state.setByte((byte)3);
        BlockBuilder builder = TinyintType.TINYINT.createFixedSizeBlockBuilder(1);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assertions.assertThat((byte)deserializedState.getByte()).isEqualTo(state.getByte());
    }

    @Test
    public void testNonPrimitiveSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(SliceState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(SliceState.class);
        SliceState state = (SliceState)factory.createSingleState();
        SliceState deserializedState = (SliceState)factory.createSingleState();
        state.setSlice(null);
        VariableWidthBlockBuilder nullBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)state, (BlockBuilder)nullBlockBuilder);
        Block nullBlock = nullBlockBuilder.build();
        serializer.deserialize(nullBlock, 0, (AccumulatorState)deserializedState);
        Assertions.assertThat((Comparable)deserializedState.getSlice()).isEqualTo((Object)state.getSlice());
        state.setSlice(Slices.utf8Slice((String)"test"));
        VariableWidthBlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)state, (BlockBuilder)builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assertions.assertThat((Comparable)deserializedState.getSlice()).isEqualTo((Object)state.getSlice());
    }

    @Test
    public void testVarianceStateSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(VarianceState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(VarianceState.class);
        VarianceState singleState = (VarianceState)factory.createSingleState();
        VarianceState deserializedState = (VarianceState)factory.createSingleState();
        singleState.setMean(1.0);
        singleState.setCount(2L);
        singleState.setM2(3.0);
        RowBlockBuilder builder = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)).createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)singleState, (BlockBuilder)builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assertions.assertThat((long)deserializedState.getCount()).isEqualTo(singleState.getCount());
        Assertions.assertThat((double)deserializedState.getMean()).isEqualTo(singleState.getMean());
        Assertions.assertThat((double)deserializedState.getM2()).isEqualTo(singleState.getM2());
    }

    @Test
    public void testComplexSerialization() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR);
        RowType rowType = RowType.anonymousRow((Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR});
        ImmutableMap fieldMap = ImmutableMap.of((Object)"Block", (Object)arrayType, (Object)"SqlMap", (Object)mapType, (Object)"SqlRow", (Object)rowType);
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(TestComplexState.class, (Map)fieldMap);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(TestComplexState.class, (Map)fieldMap);
        TestComplexState singleState = (TestComplexState)factory.createSingleState();
        TestComplexState deserializedState = (TestComplexState)factory.createSingleState();
        singleState.setBoolean(true);
        singleState.setLong(1L);
        singleState.setDouble(2.0);
        singleState.setByte((byte)3);
        singleState.setInt(4);
        singleState.setSlice(Slices.utf8Slice((String)"test"));
        singleState.setAnotherSlice(TestStateCompiler.toSlice(1.0, 2.0, 3.0));
        singleState.setYetAnotherSlice(null);
        ValueBlock array = BlockAssertions.createLongsBlock(45);
        singleState.setBlock((Block)array);
        singleState.setSqlMap(StructuralTestUtil.sqlMapOf((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)123L, (Object)"testBlock")));
        singleState.setSqlRow(StructuralTestUtil.sqlRowOf(RowType.anonymousRow((Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}), "a", 777, "b"));
        BlockBuilder builder = serializer.getSerializedType().createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)singleState, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (AccumulatorState)deserializedState);
        Assertions.assertThat((boolean)deserializedState.getBoolean()).isEqualTo(singleState.getBoolean());
        Assertions.assertThat((long)deserializedState.getLong()).isEqualTo(singleState.getLong());
        Assertions.assertThat((double)deserializedState.getDouble()).isEqualTo(singleState.getDouble());
        Assertions.assertThat((byte)deserializedState.getByte()).isEqualTo(singleState.getByte());
        Assertions.assertThat((int)deserializedState.getInt()).isEqualTo(singleState.getInt());
        Assertions.assertThat((Comparable)deserializedState.getSlice()).isEqualTo((Object)singleState.getSlice());
        Assertions.assertThat((Comparable)deserializedState.getAnotherSlice()).isEqualTo((Object)singleState.getAnotherSlice());
        Assertions.assertThat((Comparable)deserializedState.getYetAnotherSlice()).isEqualTo((Object)singleState.getYetAnotherSlice());
        Assertions.assertThat((long)BigintType.BIGINT.getLong(deserializedState.getBlock(), 0)).isEqualTo(BigintType.BIGINT.getLong(singleState.getBlock(), 0));
        SqlMap deserializedMap = deserializedState.getSqlMap();
        SqlMap expectedMap = singleState.getSqlMap();
        Assertions.assertThat((long)BigintType.BIGINT.getLong(deserializedMap.getRawKeyBlock(), deserializedMap.getRawOffset())).isEqualTo(BigintType.BIGINT.getLong(expectedMap.getRawKeyBlock(), expectedMap.getRawOffset()));
        Assertions.assertThat((Comparable)VarcharType.VARCHAR.getSlice(deserializedMap.getRawValueBlock(), deserializedMap.getRawOffset())).isEqualTo((Object)VarcharType.VARCHAR.getSlice(expectedMap.getRawValueBlock(), expectedMap.getRawOffset()));
        SqlRow sqlRow = deserializedState.getSqlRow();
        SqlRow expectedSqlRow = singleState.getSqlRow();
        Assertions.assertThat((Comparable)VarcharType.VARCHAR.getSlice(sqlRow.getRawFieldBlock(0), sqlRow.getRawIndex())).isEqualTo((Object)VarcharType.VARCHAR.getSlice(expectedSqlRow.getRawFieldBlock(0), expectedSqlRow.getRawIndex()));
        Assertions.assertThat((long)BigintType.BIGINT.getLong(sqlRow.getRawFieldBlock(1), sqlRow.getRawIndex())).isEqualTo(BigintType.BIGINT.getLong(expectedSqlRow.getRawFieldBlock(1), expectedSqlRow.getRawIndex()));
        Assertions.assertThat((Comparable)VarcharType.VARCHAR.getSlice(sqlRow.getRawFieldBlock(2), sqlRow.getRawIndex())).isEqualTo((Object)VarcharType.VARCHAR.getSlice(expectedSqlRow.getRawFieldBlock(2), expectedSqlRow.getRawIndex()));
    }

    @Test
    public void testEstimatedInOutStatesInstanceSizes() {
        AccumulatorStateFactory factory = StateCompiler.generateInOutStateFactory((Type)BigintType.BIGINT);
        InOut groupedState = (InOut)factory.createGroupedState();
        InOut singleState = (InOut)factory.createSingleState();
        long expectedGroupedSize = (long)SizeOf.instanceSize((Class)groupedState.getClass()) + new LongBigArray().sizeOf() + new BooleanBigArray().sizeOf();
        Assertions.assertThat((long)groupedState.getEstimatedSize()).isEqualTo(expectedGroupedSize).isEqualTo(17568L);
        Assertions.assertThat((long)singleState.getEstimatedSize()).isEqualTo((long)SizeOf.instanceSize((Class)singleState.getClass())).isEqualTo(24L);
    }

    @Test
    public void testEstimatedStateInstanceSizes() {
        AccumulatorStateFactory stateFactory = StateCompiler.generateStateFactory(TestSimpleState.class);
        TestSimpleState groupedState = (TestSimpleState)stateFactory.createGroupedState();
        TestSimpleState singleState = (TestSimpleState)stateFactory.createSingleState();
        long expectedGroupedSize = (long)SizeOf.instanceSize(groupedState.getClass()) + new LongBigArray().sizeOf() + new DoubleBigArray().sizeOf();
        Assertions.assertThat((long)groupedState.getEstimatedSize()).isEqualTo(expectedGroupedSize).isEqualTo(24744L);
        Assertions.assertThat((long)singleState.getEstimatedSize()).isEqualTo((long)SizeOf.instanceSize(singleState.getClass())).isEqualTo(32L);
    }

    private static Slice toSlice(double ... values) {
        Slice slice = Slices.allocate((int)(values.length * 8));
        SliceOutput output = slice.getOutput();
        for (double value : values) {
            output.writeDouble(value);
        }
        return slice;
    }

    public static interface BooleanState
    extends AccumulatorState {
        public boolean isBoolean();

        public void setBoolean(boolean var1);
    }

    public static interface ByteState
    extends AccumulatorState {
        public byte getByte();

        public void setByte(byte var1);
    }

    public static interface SliceState
    extends AccumulatorState {
        public Slice getSlice();

        public void setSlice(Slice var1);
    }

    public static interface TestComplexState
    extends AccumulatorState {
        public double getDouble();

        public void setDouble(double var1);

        public boolean getBoolean();

        public void setBoolean(boolean var1);

        public long getLong();

        public void setLong(long var1);

        public byte getByte();

        public void setByte(byte var1);

        public int getInt();

        public void setInt(int var1);

        public Slice getSlice();

        public void setSlice(Slice var1);

        public Slice getAnotherSlice();

        public void setAnotherSlice(Slice var1);

        public Slice getYetAnotherSlice();

        public void setYetAnotherSlice(Slice var1);

        public Block getBlock();

        public void setBlock(Block var1);

        public SqlMap getSqlMap();

        public void setSqlMap(SqlMap var1);

        public SqlRow getSqlRow();

        public void setSqlRow(SqlRow var1);
    }

    public static interface TestSimpleState
    extends AccumulatorState {
        public long getLong();

        public void setLong(long var1);

        public double getDouble();

        public void setDouble(double var1);
    }
}

