/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.collect.ImmutableList;
import io.trino.operator.join.JoinProbe;
import io.trino.operator.join.LookupJoinPageBuilder;
import io.trino.operator.join.LookupSource;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.OptionalInt;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLookupJoinPageBuilder {
    @Test
    public void testPageBuilder() {
        int entries = 10000;
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block});
        JoinProbe.JoinProbeFactory joinProbeFactory = new JoinProbe.JoinProbeFactory(new int[]{0, 1}, (List)ImmutableList.of((Object)0, (Object)1), OptionalInt.empty());
        JoinProbe probe = joinProbeFactory.createJoinProbe(page);
        TestLookupSource lookupSource = new TestLookupSource((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), page);
        LookupJoinPageBuilder lookupJoinPageBuilder = new LookupJoinPageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        int joinPosition = 0;
        while (!lookupJoinPageBuilder.isFull() && probe.advanceNextPosition()) {
            lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, (long)joinPosition++);
            lookupJoinPageBuilder.appendNullForBuild(probe);
        }
        Assertions.assertThat((boolean)lookupJoinPageBuilder.isEmpty()).isFalse();
        Page output = lookupJoinPageBuilder.build(probe);
        Assertions.assertThat((int)output.getChannelCount()).isEqualTo(4);
        Assertions.assertThat((boolean)(output.getBlock(0) instanceof DictionaryBlock)).isTrue();
        Assertions.assertThat((boolean)(output.getBlock(1) instanceof DictionaryBlock)).isTrue();
        for (int i = 0; i < output.getPositionCount(); ++i) {
            Assertions.assertThat((boolean)output.getBlock(0).isNull(i)).isFalse();
            Assertions.assertThat((boolean)output.getBlock(1).isNull(i)).isFalse();
            Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(0), i)).isEqualTo((long)(i / 2));
            Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(1), i)).isEqualTo((long)(i / 2));
            if (i % 2 == 0) {
                Assertions.assertThat((boolean)output.getBlock(2).isNull(i)).isFalse();
                Assertions.assertThat((boolean)output.getBlock(3).isNull(i)).isFalse();
                Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(2), i)).isEqualTo((long)(i / 2));
                Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(3), i)).isEqualTo((long)(i / 2));
                continue;
            }
            Assertions.assertThat((boolean)output.getBlock(2).isNull(i)).isTrue();
            Assertions.assertThat((boolean)output.getBlock(3).isNull(i)).isTrue();
        }
        Assertions.assertThat((boolean)lookupJoinPageBuilder.toString().contains("positionCount=" + output.getPositionCount())).isTrue();
        lookupJoinPageBuilder.reset();
        Assertions.assertThat((boolean)lookupJoinPageBuilder.isEmpty()).isTrue();
    }

    @Test
    public void testDifferentPositions() {
        int i;
        int entries = 100;
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(entries);
        for (int i2 = 0; i2 < entries; ++i2) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i2);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block});
        JoinProbe.JoinProbeFactory joinProbeFactory = new JoinProbe.JoinProbeFactory(new int[]{0}, (List)ImmutableList.of((Object)0), OptionalInt.empty());
        TestLookupSource lookupSource = new TestLookupSource((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), page);
        LookupJoinPageBuilder lookupJoinPageBuilder = new LookupJoinPageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT));
        JoinProbe probe = joinProbeFactory.createJoinProbe(page);
        Page output = lookupJoinPageBuilder.build(probe);
        Assertions.assertThat((int)output.getChannelCount()).isEqualTo(2);
        Assertions.assertThat((Object)output.getBlock(0)).isInstanceOf(LongArrayBlock.class);
        Assertions.assertThat((int)output.getPositionCount()).isEqualTo(0);
        lookupJoinPageBuilder.reset();
        probe = joinProbeFactory.createJoinProbe(page);
        int joinPosition = 0;
        while (probe.advanceNextPosition()) {
            if (joinPosition % 2 != 1) {
                lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, (long)joinPosition);
            }
            ++joinPosition;
        }
        output = lookupJoinPageBuilder.build(probe);
        Assertions.assertThat((int)output.getChannelCount()).isEqualTo(2);
        Assertions.assertThat((Object)output.getBlock(0)).isInstanceOf(DictionaryBlock.class);
        Assertions.assertThat((int)output.getPositionCount()).isEqualTo(entries / 2);
        for (i = 0; i < entries / 2; ++i) {
            Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(0), i)).isEqualTo((long)i * 2L);
            Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(1), i)).isEqualTo((long)i * 2L);
        }
        lookupJoinPageBuilder.reset();
        probe = joinProbeFactory.createJoinProbe(page);
        joinPosition = 0;
        while (probe.advanceNextPosition()) {
            lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, (long)joinPosition);
            ++joinPosition;
        }
        output = lookupJoinPageBuilder.build(probe);
        Assertions.assertThat((int)output.getChannelCount()).isEqualTo(2);
        Assertions.assertThat((Object)output.getBlock(0)).isNotInstanceOf(DictionaryBlock.class);
        Assertions.assertThat((int)output.getPositionCount()).isEqualTo(entries);
        for (i = 0; i < entries; ++i) {
            Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(0), i)).isEqualTo((long)i);
            Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(1), i)).isEqualTo((long)i);
        }
        lookupJoinPageBuilder.reset();
        probe = joinProbeFactory.createJoinProbe(page);
        joinPosition = 0;
        while (probe.advanceNextPosition()) {
            if (joinPosition >= 10 && joinPosition < 50) {
                lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, (long)joinPosition);
            }
            ++joinPosition;
        }
        output = lookupJoinPageBuilder.build(probe);
        Assertions.assertThat((int)output.getChannelCount()).isEqualTo(2);
        Assertions.assertThat((Object)output.getBlock(0)).isNotInstanceOf(DictionaryBlock.class);
        Assertions.assertThat((int)output.getPositionCount()).isEqualTo(40);
        for (i = 10; i < 50; ++i) {
            Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(0), i - 10)).isEqualTo((long)i);
            Assertions.assertThat((long)BigintType.BIGINT.getLong(output.getBlock(1), i - 10)).isEqualTo((long)i);
        }
    }

    @Test
    public void testCrossJoinWithEmptyBuild() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(1);
        BigintType.BIGINT.writeLong(blockBuilder, 0L);
        Page page = new Page(new Block[]{blockBuilder.build()});
        TestLookupSource lookupSource = new TestLookupSource((List<Type>)ImmutableList.of(), page);
        JoinProbe probe = new JoinProbe.JoinProbeFactory(new int[]{0}, (List)ImmutableList.of((Object)0), OptionalInt.empty()).createJoinProbe(page);
        LookupJoinPageBuilder lookupJoinPageBuilder = new LookupJoinPageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT));
        probe.advanceNextPosition();
        for (int i = 0; i < 300000; ++i) {
            lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, 0L);
        }
        Assertions.assertThat((boolean)lookupJoinPageBuilder.isFull()).isTrue();
    }

    private static final class TestLookupSource
    implements LookupSource {
        private final List<Type> types;
        private final Page page;

        public TestLookupSource(List<Type> types, Page page) {
            this.types = types;
            this.page = page;
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public long getJoinPositionCount() {
            throw new UnsupportedOperationException();
        }

        public long joinPositionWithinPartition(long joinPosition) {
            throw new UnsupportedOperationException();
        }

        public long getInMemorySizeInBytes() {
            throw new UnsupportedOperationException();
        }

        public long getJoinPosition(int position, Page page, Page allChannelsPage, long rawHash) {
            throw new UnsupportedOperationException();
        }

        public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
            throw new UnsupportedOperationException();
        }

        public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
            throw new UnsupportedOperationException();
        }

        public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
            throw new UnsupportedOperationException();
        }

        public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
            for (int i = 0; i < this.types.size(); ++i) {
                this.types.get(i).appendTo(this.page.getBlock(i), (int)position, pageBuilder.getBlockBuilder(i));
            }
        }

        public void close() {
        }
    }
}

