/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.server.protocol.spooling.SpoolingConfig;
import io.trino.util.Ciphers;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

class TestSpoolingConfig {
    TestSpoolingConfig() {
    }

    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((SpoolingConfig)ConfigAssertions.recordDefaults(SpoolingConfig.class)).setSharedSecretKey(null).setRetrievalMode(SpoolingConfig.SegmentRetrievalMode.STORAGE).setStorageRedirectTtl(Optional.empty()).setInitialSegmentSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaximumSegmentSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaximumInlinedRows(1000L).setMaximumInlinedSize(DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setAllowInlining(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        String randomAesEncryptionKey = Base64.getEncoder().encodeToString(Ciphers.createRandomAesEncryptionKey().getEncoded());
        ImmutableMap properties = ImmutableMap.builder().put((Object)"protocol.spooling.shared-secret-key", (Object)randomAesEncryptionKey).put((Object)"protocol.spooling.retrieval-mode", (Object)"coordinator_storage_redirect").put((Object)"protocol.spooling.coordinator-storage-redirect-ttl", (Object)"60s").put((Object)"protocol.spooling.inlining.enabled", (Object)"false").put((Object)"protocol.spooling.initial-segment-size", (Object)"1kB").put((Object)"protocol.spooling.maximum-segment-size", (Object)"8kB").put((Object)"protocol.spooling.inlining.max-rows", (Object)"1024").put((Object)"protocol.spooling.inlining.max-size", (Object)"1MB").buildOrThrow();
        SpoolingConfig expected = new SpoolingConfig().setRetrievalMode(SpoolingConfig.SegmentRetrievalMode.COORDINATOR_STORAGE_REDIRECT).setStorageRedirectTtl(Optional.of(Duration.valueOf((String)"60s"))).setSharedSecretKey(randomAesEncryptionKey).setInitialSegmentSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaximumSegmentSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaximumInlinedRows(1024L).setMaximumInlinedSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setAllowInlining(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

