/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.slice.Slices;
import io.trino.FeaturesConfig;
import io.trino.RowPagesBuilder;
import io.trino.execution.buffer.PageSerializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.PageAssertions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.FileSingleStreamSpillerFactory;
import io.trino.spiller.GenericSpillerFactory;
import io.trino.spiller.NodeSpillConfig;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.spiller.Spiller;
import io.trino.spiller.SpillerFactory;
import io.trino.spiller.SpillerStats;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestBinaryFileSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT);
    private File spillPath;
    private SpillerStats spillerStats;
    private FileSingleStreamSpillerFactory singleStreamSpillerFactory;
    private SpillerFactory factory;
    private PageSerializer serializer;
    private AggregatedMemoryContext memoryContext;

    @BeforeAll
    public void setUpClass() throws IOException {
        this.spillPath = Files.createTempDirectory("tmp", new FileAttribute[0]).toFile();
    }

    @BeforeEach
    public void setUp() {
        this.spillerStats = new SpillerStats();
        FeaturesConfig featuresConfig = new FeaturesConfig();
        featuresConfig.setSpillerSpillPaths((List)ImmutableList.of((Object)this.spillPath.getAbsolutePath()));
        featuresConfig.setSpillMaxUsedSpaceThreshold(1.0);
        NodeSpillConfig nodeSpillConfig = new NodeSpillConfig();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory((BlockEncodingSerde)blockEncodingSerde, this.spillerStats, featuresConfig, nodeSpillConfig);
        this.factory = new GenericSpillerFactory((SingleStreamSpillerFactory)this.singleStreamSpillerFactory);
        PagesSerdeFactory pagesSerdeFactory = new PagesSerdeFactory((BlockEncodingSerde)blockEncodingSerde, nodeSpillConfig.getSpillCompressionCodec());
        this.serializer = pagesSerdeFactory.createSerializer(Optional.empty());
        this.memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.singleStreamSpillerFactory.destroy();
        MoreFiles.deleteRecursively((Path)this.spillPath.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testFileSpiller() throws Exception {
        try (Spiller spiller = this.factory.create(TYPES, bytes -> {}, this.memoryContext);){
            this.testSimpleSpiller(spiller);
        }
    }

    @Test
    public void testFileVarbinarySpiller() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarbinaryType.VARBINARY);
        BlockBuilder col1 = BigintType.BIGINT.createFixedSizeBlockBuilder(1);
        BlockBuilder col2 = DoubleType.DOUBLE.createFixedSizeBlockBuilder(1);
        VariableWidthBlockBuilder col3 = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        BigintType.BIGINT.writeLong(col1, 42L);
        DoubleType.DOUBLE.writeDouble(col2, 43.0);
        VarbinaryType.VARBINARY.writeSlice((BlockBuilder)col3, Slices.allocate((int)16).getOutput().appendDouble(43.0).appendLong(1L).slice());
        Page page = new Page(new Block[]{col1.build(), col2.build(), col3.build()});
        try (Spiller spiller = this.factory.create(TYPES, bytes -> {}, this.memoryContext);){
            this.testSpiller((List<Type>)types, spiller, new List[]{ImmutableList.of((Object)page)});
        }
    }

    private void testSimpleSpiller(Spiller spiller) throws ExecutionException, InterruptedException {
        RowPagesBuilder builder = RowPagesBuilder.rowPagesBuilder(TYPES);
        builder.addSequencePage(10, 0, 5, 10, 15);
        builder.pageBreak();
        builder.addSequencePage(10, 0, -5, -10, -15);
        List<Page> firstSpill = builder.build();
        builder = RowPagesBuilder.rowPagesBuilder(TYPES);
        builder.addSequencePage(10, 10, 15, 20, 25);
        builder.pageBreak();
        builder.addSequencePage(10, -10, -15, -20, -25);
        List<Page> secondSpill = builder.build();
        this.testSpiller(TYPES, spiller, firstSpill, secondSpill);
    }

    @SafeVarargs
    private void testSpiller(List<Type> types, Spiller spiller, List<Page> ... spills) throws ExecutionException, InterruptedException {
        long spilledBytesBefore = this.spillerStats.getTotalSpilledBytes();
        long spilledBytes = 0L;
        Assertions.assertThat((long)this.memoryContext.getBytes()).isEqualTo(0L);
        for (List<Page> spill : spills) {
            spilledBytes += spill.stream().mapToLong(page -> this.serializer.serialize(page).length()).sum();
            spiller.spill(spill.iterator()).get();
        }
        Assertions.assertThat((long)(this.spillerStats.getTotalSpilledBytes() - spilledBytesBefore)).isEqualTo(spilledBytes);
        Assertions.assertThat((long)this.memoryContext.getBytes()).isEqualTo((long)spills.length * 4096L);
        List actualSpills = spiller.getSpills();
        Assertions.assertThat((int)actualSpills.size()).isEqualTo(spills.length);
        for (int i = 0; i < actualSpills.size(); ++i) {
            ImmutableList actualSpill = ImmutableList.copyOf((Iterator)((Iterator)actualSpills.get(i)));
            List<Page> expectedSpill = spills[i];
            Assertions.assertThat((int)actualSpill.size()).isEqualTo(expectedSpill.size());
            for (int j = 0; j < actualSpill.size(); ++j) {
                PageAssertions.assertPageEquals(types, (Page)actualSpill.get(j), expectedSpill.get(j));
            }
        }
        spiller.close();
        Assertions.assertThat((long)this.memoryContext.getBytes()).isEqualTo(0L);
    }
}

