/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.optimizer.rule.EvaluateFieldReference;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvaluateFieldReference {
    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new FieldReference((Expression)new Row((List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))), 1))).isEqualTo(Optional.of(new Reference((Type)BigintType.BIGINT, "b")));
        Assertions.assertThat(this.optimize((Expression)new FieldReference((Expression)new Constant((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), null), 1))).isEqualTo(Optional.of(new Constant((Type)BigintType.BIGINT, null)));
        Assertions.assertThat(this.optimize((Expression)new FieldReference((Expression)IrExpressions.row((List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)), 1))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "x"), 1))).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateFieldReference().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

