/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.rule.RemoveRedundantCaseClauses;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantCaseClauses {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution(InMemoryTransactionManager.createTestTransactionManager(), TestingPlannerContext.PLANNER_CONTEXT);
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", (List<TypeSignatureProvider>)ImmutableList.of());

    @Test
    void test() {
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r1")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r2")), (Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Reference((Type)VarcharType.VARCHAR, "r3")), (Object)new WhenClause((Expression)Booleans.NULL_BOOLEAN, (Expression)new Reference((Type)VarcharType.VARCHAR, "r4")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r5"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "d")))).describedAs("redundant terms", new Object[0])).isEqualTo(Optional.of(new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r1")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r2"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "d"))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r1")), (Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Reference((Type)VarcharType.VARCHAR, "r2"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "d")))).describedAs("short-circuit", new Object[0])).isEqualTo(Optional.of(new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r1"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "r2"))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Reference((Type)VarcharType.VARCHAR, "r1")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r2"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "d")))).describedAs("short-circuit on first term", new Object[0])).isEqualTo(Optional.of(new Reference((Type)VarcharType.VARCHAR, "r1")));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r1")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r2")), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Expression)new Reference((Type)VarcharType.VARCHAR, "r3")), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Expression)new Reference((Type)VarcharType.VARCHAR, "r4")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r5"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "d")))).describedAs("non-deterministic terms", new Object[0])).isEqualTo(Optional.of(new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r1")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Reference((Type)VarcharType.VARCHAR, "r2")), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Expression)new Reference((Type)VarcharType.VARCHAR, "r3")), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Expression)new Reference((Type)VarcharType.VARCHAR, "r4"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "d"))));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new RemoveRedundantCaseClauses().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

