/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.SimplifyContinuousInValues;
import io.trino.testing.TestingSession;
import io.trino.type.Reals;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestSimplifyContinuousInValues {
    @Test
    void test() {
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))).describedAs("non-constant list", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of()))).describedAs("empty list", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))).describedAs("single value list", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))).describedAs("null value, single value list", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))))).describedAs("continuous values with null", new Object[0])).isEqualTo(Optional.of(IrUtils.or((Expression[])new Expression[]{new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "x")), new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L))})));
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L), (Object)new Constant((Type)BigintType.BIGINT, (Object)3L))))).describedAs("non-null continuous values", new Object[0])).isEqualTo(Optional.of(new Between((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L))));
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L), (Object)new Constant((Type)BigintType.BIGINT, (Object)3L))))).describedAs("repeated continuous values", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L), (Object)new Constant((Type)BigintType.BIGINT, (Object)4L), (Object)new Constant((Type)BigintType.BIGINT, (Object)5L))))).describedAs("discontinuous values", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE), (Object)new Constant((Type)BigintType.BIGINT, (Object)Long.MIN_VALUE))))).describedAs("overflow handling", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)2.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)3.0))))).describedAs("unsupported type", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)new In((Expression)new Reference((Type)RealType.REAL, "x"), (List)ImmutableList.of((Object)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)), (Object)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)2.0f)), (Object)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)3.0f)))))).describedAs("unsupported type", new Object[0])).isEqualTo(Optional.empty());
    }

    @Test
    public void verifySupportedTypeAssumptions() {
        for (Type type : TestSimplifyContinuousInValues.supportedTypes()) {
            Assertions.assertThat((Class)type.getJavaType()).isEqualTo(Long.TYPE);
            BlockBuilder blockBuilder = type.createBlockBuilder(null, 201);
            Long currentValue = 0L;
            for (int i2 = 0; i2 < 100; ++i2) {
                TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)currentValue);
                currentValue = type.getNextValue((Object)currentValue).orElseThrow(() -> new RuntimeException("type " + String.valueOf(type)));
            }
            Block block = blockBuilder.build();
            boolean areRepresentationValuesContinuous = true;
            for (int i3 = 0; i3 < block.getPositionCount() - 1; ++i3) {
                if (type.getLong(block, i3) + 1L == type.getLong(block, i3 + 1)) continue;
                areRepresentationValuesContinuous = false;
                break;
            }
            List valuesList = (List)IntStream.range(0, block.getPositionCount()).mapToObj(i -> new Constant(type, (Object)type.getLong(block, i))).collect(ImmutableList.toImmutableList());
            In in = new In((Expression)new Reference(type, "x"), valuesList);
            if (areRepresentationValuesContinuous) {
                Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)in)).isEqualTo(Optional.of(new Between((Expression)new Reference(type, "x"), (Expression)new Constant(type, (Object)type.getLong(block, 0)), (Expression)new Constant(type, (Object)type.getLong(block, block.getPositionCount() - 1)))));
                continue;
            }
            Assertions.assertThat(TestSimplifyContinuousInValues.optimize((Expression)in)).isEmpty();
        }
    }

    private static List<Type> supportedTypes() {
        return ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)SmallintType.SMALLINT, (Object)TinyintType.TINYINT, (Object)TimestampType.TIMESTAMP_SECONDS, (Object)TimestampType.TIMESTAMP_MILLIS, (Object)TimestampType.TIMESTAMP_MICROS, (Object)TimeType.TIME_SECONDS, (Object)TimeType.TIME_MILLIS, (Object)TimeType.TIME_MICROS, (Object)TimeType.TIME_NANOS, (Object)TimeType.TIME_PICOS, (Object[])new Type[]{DateType.DATE, DecimalType.createDecimalType((int)5, (int)0), DecimalType.createDecimalType((int)7, (int)2)});
    }

    private static Optional<Expression> optimize(Expression expression) {
        return new SimplifyContinuousInValues().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

