/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.SessionTestUtils;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestLocalExecutionPlanner {
    private QueryRunner runner;

    @BeforeAll
    public void setUp() {
        this.runner = new StandaloneQueryRunner(SessionTestUtils.TEST_SESSION);
        this.runner.installPlugin((Plugin)new TpchPlugin());
        this.runner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of());
    }

    @AfterAll
    public void cleanup() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.runner});
        this.runner = null;
    }

    @Test
    public void testProjectionCompilerFailure() {
        String inner = "(" + Joiner.on((String)" + ").join(Collections.nCopies(100, "rand()")) + ")";
        String outer = "x + x + " + Joiner.on((String)" + ").join(Collections.nCopies(100, inner));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.runner.execute("SELECT " + outer + " FROM (VALUES rand()) t(x)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.QUERY_EXCEEDED_COMPILER_LIMIT}).hasMessage("Query exceeded maximum columns. Please reduce the number of columns referenced and re-run the query.");
    }

    @Test
    public void testFilterCompilerFailure() {
        String filterQueryInner = "FROM (SELECT rand() as c1, rand() as c2, rand() as c3)";
        String filterQueryWhere = "WHERE c1 = rand() OR " + Joiner.on((String)" AND ").join(Collections.nCopies(1000, "c1 = rand()")) + " OR " + Joiner.on((String)" AND ").join(Collections.nCopies(1000, " c2 = rand()")) + " OR " + Joiner.on((String)" AND ").join(Collections.nCopies(1000, " c3 = rand()"));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.runner.execute("SELECT * " + filterQueryInner + filterQueryWhere)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.QUERY_EXCEEDED_COMPILER_LIMIT}).hasMessage("Query exceeded maximum filters. Please reduce the number of filters referenced and re-run the query.");
    }

    @Test
    public void testExpressionCompilerFailure() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.runner.execute("SELECT concat(name) FROM nation")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessageStartingWith("There must be two or more concatenation arguments");
    }
}

