/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;

public class StatsOutputRowCountMatcher
implements Matcher {
    private final double expectedOutputRowCount;

    StatsOutputRowCountMatcher(double expectedOutputRowCount) {
        this.expectedOutputRowCount = expectedOutputRowCount;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        return new MatchResult(Double.compare(stats.getStats(node).getOutputRowCount(), this.expectedOutputRowCount) == 0);
    }

    public String toString() {
        return "expectedOutputRowCount(" + this.expectedOutputRowCount + ")";
    }
}

