/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Plan;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkReorderChainedJoins {
    @Benchmark
    public Plan benchmarkReorderJoins(BenchmarkInfo benchmarkInfo) {
        PlanTester planTester = benchmarkInfo.getPlanTester();
        return (Plan)planTester.inTransaction(transactionSession -> planTester.createPlan(transactionSession, "SELECT *\nFROM nation n1\nJOIN nation n2 ON n1.nationkey = n2.nationkey\nJOIN nation n3 ON n2.comment = n3.comment\nJOIN nation n4 ON n3.name = n4.name\nJOIN region r1 ON n4.regionkey = r1.regionkey\nJOIN region r2 ON r1.name = r2.name\nJOIN region r3 ON r3.comment = r2.comment\nJOIN region r4 ON r4.regionkey = r3.regionkey\n"));
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkReorderChainedJoins.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkInfo {
        @Param(value={"ELIMINATE_CROSS_JOINS", "AUTOMATIC"})
        private String joinReorderingStrategy;
        private PlanTester planTester;

        @Setup
        public void setup() {
            Session session = TestingSession.testSessionBuilder().setSystemProperty("join_reordering_strategy", this.joinReorderingStrategy).setSystemProperty("join_distribution_type", "AUTOMATIC").setCatalog("tpch").setSchema("tiny").build();
            this.planTester = PlanTester.create((Session)session);
            this.planTester.installPlugin((Plugin)new TpchPlugin());
            this.planTester.createCatalog("tpch", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        }

        public PlanTester getPlanTester() {
            return this.planTester;
        }

        @TearDown
        public void tearDown() {
            this.planTester.close();
        }
    }
}

