/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.cost.TaskCountEstimator;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SetOperationOutputMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MultipleDistinctAggregationsToSubqueries;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTransactionHandle;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class TestMultipleDistinctAggregationsToSubqueries
extends BaseRuleTest {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").build();
    private static final String COLUMN_1 = "orderkey";
    private static final ColumnHandle COLUMN_1_HANDLE = new MockConnectorColumnHandle("orderkey", (Type)BigintType.BIGINT);
    private static final String COLUMN_2 = "partkey";
    private static final ColumnHandle COLUMN_2_HANDLE = new MockConnectorColumnHandle("partkey", (Type)BigintType.BIGINT);
    private static final String COLUMN_3 = "linenumber";
    private static final ColumnHandle COLUMN_3_HANDLE = new MockConnectorColumnHandle("linenumber", (Type)BigintType.BIGINT);
    private static final String COLUMN_4 = "shipdate";
    private static final ColumnHandle COLUMN_4_HANDLE = new MockConnectorColumnHandle("shipdate", (Type)DateType.DATE);
    private static final String GROUPING_KEY_COLUMN = "suppkey";
    private static final ColumnHandle GROUPING_KEY_COLUMN_HANDLE = new MockConnectorColumnHandle("suppkey", (Type)BigintType.BIGINT);
    private static final String GROUPING_KEY2_COLUMN = "comment";
    private static final ColumnHandle GROUPING_KEY2_COLUMN_HANDLE = new MockConnectorColumnHandle("comment", (Type)VarcharType.VARCHAR);
    private static final SchemaTableName TABLE_SCHEMA = new SchemaTableName("test_schema", "test_table");
    private static final List<ColumnMetadata> ALL_COLUMNS = (List)Stream.of(COLUMN_1_HANDLE, COLUMN_2_HANDLE, COLUMN_3_HANDLE, COLUMN_4_HANDLE, GROUPING_KEY_COLUMN_HANDLE, GROUPING_KEY2_COLUMN_HANDLE).map(columnHandle -> (MockConnectorColumnHandle)columnHandle).map(column -> new ColumnMetadata(column.getName(), column.getType())).collect(ImmutableList.toImmutableList());
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private RuleTester ruleTester = TestMultipleDistinctAggregationsToSubqueries.tester(true);

    public TestMultipleDistinctAggregationsToSubqueries() {
        super(new Plugin[0]);
    }

    @AfterAll
    public final void tearDownTester() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.ruleTester});
        this.ruleTester = null;
    }

    @Test
    public void testDoesNotFire() {
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol inputSymbol = p.symbol("inputSymbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.singleGroupingSet(inputSymbol).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)inputSymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)inputSymbol, (Object)COLUMN_1_HANDLE))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol inputSymbol = p.symbol("inputSymbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "inputSymbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)inputSymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)inputSymbol, (Object)COLUMN_1_HANDLE))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).hashSymbol(p.symbol("hashSymbol", (Type)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output3", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.groupingSets(AggregationNode.groupingSets((List)ImmutableList.of(), (int)2, (Set)ImmutableSet.of((Object)0, (Object)1))).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.join(JoinType.INNER, (PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()), (PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE)), new JoinNode.EquiJoinClause[0])));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.filter((Expression)Booleans.TRUE, (PlanNode)p.join(JoinType.INNER, (PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()), (PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE)), new JoinNode.EquiJoinClause[0]))));
        }).doesNotFire();
        RuleTester ruleTesterNotObjectStore = TestMultipleDistinctAggregationsToSubqueries.tester(false);
        ruleTesterNotObjectStore.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(ruleTesterNotObjectStore)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(ruleTesterNotObjectStore), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "single_step").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE))));
        }).doesNotFire();
        String aggregationSourceId = "aggregationSourceId";
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId, PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "groupingKey"), SymbolStatsEstimate.builder().setDistinctValuesCount(1000000.0).build()).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(tableScan -> tableScan.setNodeId(new PlanNodeId(aggregationSourceId)).setTableHandle(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester)).setSymbols((List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE)))));
        }).doesNotFire();
    }

    @Test
    public void testAutomaticDecisionForAggregationOnTableScan() {
        String aggregationSourceId = "aggregationSourceId";
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId, PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "groupingKey"), SymbolStatsEstimate.builder().setDistinctValuesCount(1000000.0).build()).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(tableScan -> tableScan.setNodeId(new PlanNodeId(aggregationSourceId)).setTableHandle(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester)).setSymbols((List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE)))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "groupingKey"), SymbolStatsEstimate.builder().setDistinctValuesCount(10.0).build()).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol groupingKey = p.symbol("groupingKey", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.singleGroupingSet(groupingKey).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(tableScan -> tableScan.setNodeId(new PlanNodeId(aggregationSourceId)).setTableHandle(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester)).setSymbols((List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol, (Object)groupingKey)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE, (Object)groupingKey, (Object)GROUPING_KEY_COLUMN_HANDLE)))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"final_output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output1")), (Object)"final_output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2")), (Object)"group_by_key", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "left_groupingKey"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("left_groupingKey", "right_groupingKey").left(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("left_groupingKey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("output1"), PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input1Symbol")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1Symbol", (Object)COLUMN_1, (Object)"left_groupingKey", (Object)GROUPING_KEY_COLUMN)))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("right_groupingKey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("output2"), PlanMatchPattern.aggregationFunction("sum", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input2Symbol")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input2Symbol", (Object)COLUMN_2, (Object)"right_groupingKey", (Object)GROUPING_KEY_COLUMN)))))));
        String aggregationId = "aggregationId";
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "groupingKey"), SymbolStatsEstimate.builder().setDistinctValuesCount(10.0).build()).addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "groupingKey2"), SymbolStatsEstimate.builder().setAverageRowSize(1000000.0).build()).build()).overrideStats(aggregationId, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol groupingKey = p.symbol("groupingKey", (Type)BigintType.BIGINT);
            Symbol groupingKey2 = p.symbol("groupingKey2", (Type)VarcharType.VARCHAR);
            return p.aggregation(builder -> builder.nodeId(new PlanNodeId(aggregationId)).singleGroupingSet(groupingKey, groupingKey2).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(tableScan -> tableScan.setNodeId(new PlanNodeId(aggregationSourceId)).setTableHandle(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester)).setSymbols((List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol, (Object)groupingKey, (Object)groupingKey2)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE, (Object)groupingKey, (Object)GROUPING_KEY_COLUMN_HANDLE, (Object)groupingKey2, (Object)GROUPING_KEY2_COLUMN_HANDLE)))));
        }).doesNotFire();
    }

    @Test
    public void testAutomaticDecisionForAggregationOnProjectedTableScan() {
        String aggregationSourceId = "aggregationSourceId";
        String aggregationId = "aggregationId";
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "projectionInput1"), SymbolStatsEstimate.builder().setDistinctValuesCount(10.0).build()).addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "projectionInput2"), SymbolStatsEstimate.builder().setAverageRowSize(1000000.0).build()).build()).overrideStats(aggregationId, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol groupingKey = p.symbol("groupingKey", (Type)BigintType.BIGINT);
            Symbol projectionInput1 = p.symbol("projectionInput1", (Type)BigintType.BIGINT);
            Symbol projectionInput2 = p.symbol("projectionInput2", (Type)VarcharType.VARCHAR);
            return p.aggregation(builder -> builder.nodeId(new PlanNodeId(aggregationId)).singleGroupingSet(groupingKey).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().putIdentity(input1Symbol).putIdentity(input2Symbol).put(groupingKey, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "projectionInput1"), (Object)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "projectionInput2"), (Type)BigintType.BIGINT)))).build(), (PlanNode)p.tableScan(tableScan -> tableScan.setNodeId(new PlanNodeId(aggregationSourceId)).setTableHandle(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester)).setSymbols((List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol, (Object)projectionInput1, (Object)projectionInput2)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE, (Object)projectionInput1, (Object)GROUPING_KEY_COLUMN_HANDLE, (Object)projectionInput2, (Object)GROUPING_KEY2_COLUMN_HANDLE))))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "projectionInput1"), SymbolStatsEstimate.builder().setDistinctValuesCount(10.0).build()).addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "projectionInput2"), SymbolStatsEstimate.builder().setAverageRowSize(1000000.0).build()).build()).overrideStats(aggregationId, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol groupingKey = p.symbol("groupingKey", (Type)BigintType.BIGINT);
            Symbol projectionInput1 = p.symbol("projectionInput1", (Type)BigintType.BIGINT);
            Symbol projectionInput2 = p.symbol("projectionInput2", (Type)VarcharType.VARCHAR);
            return p.aggregation(builder -> builder.nodeId(new PlanNodeId(aggregationId)).singleGroupingSet(groupingKey).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().put(input1Symbol, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "projectionInput1"), (Object)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "projectionInput2"), (Type)BigintType.BIGINT)))).putIdentity(input2Symbol).putIdentity(groupingKey).build(), (PlanNode)p.tableScan(tableScan -> tableScan.setNodeId(new PlanNodeId(aggregationSourceId)).setTableHandle(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester)).setSymbols((List<Symbol>)ImmutableList.of((Object)groupingKey, (Object)input2Symbol, (Object)projectionInput1, (Object)projectionInput2)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)groupingKey, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE, (Object)projectionInput1, (Object)GROUPING_KEY_COLUMN_HANDLE, (Object)projectionInput2, (Object)GROUPING_KEY2_COLUMN_HANDLE))))));
        }).doesNotFire();
    }

    @Test
    public void testAutomaticDecisionForAggregationOnFilteredTableScan() {
        String aggregationSourceId = "aggregationSourceId";
        String aggregationId = "aggregationId";
        String filterId = "filterId";
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)VarcharType.VARCHAR, "filterInput"), SymbolStatsEstimate.builder().setAverageRowSize(1.0).build()).build()).overrideStats(filterId, PlanNodeStatsEstimate.builder().setOutputRowCount(1.0).build()).overrideStats(aggregationId, PlanNodeStatsEstimate.builder().setOutputRowCount(1.0).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol groupingKey = p.symbol("groupingKey", (Type)BigintType.BIGINT);
            Symbol filterInput = p.symbol("filterInput", (Type)VarcharType.VARCHAR);
            return p.aggregation(builder -> builder.nodeId(new PlanNodeId(aggregationId)).singleGroupingSet(groupingKey).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.filter(new PlanNodeId(filterId), IrExpressions.not((Metadata)this.ruleTester.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, "filterInput"))), (PlanNode)p.tableScan(tableScan -> tableScan.setNodeId(new PlanNodeId(aggregationSourceId)).setTableHandle(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester)).setSymbols((List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol, (Object)groupingKey, (Object)filterInput)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE, (Object)groupingKey, (Object)GROUPING_KEY_COLUMN_HANDLE, (Object)filterInput, (Object)GROUPING_KEY2_COLUMN_HANDLE))))));
        }).doesNotFire();
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)VarcharType.VARCHAR, "filterInput"), SymbolStatsEstimate.builder().setAverageRowSize(1.0).build()).build()).overrideStats(filterId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).build()).overrideStats(aggregationId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol groupingKey = p.symbol("groupingKey", (Type)BigintType.BIGINT);
            Symbol filterInput = p.symbol("filterInput", (Type)VarcharType.VARCHAR);
            return p.aggregation(builder -> builder.nodeId(new PlanNodeId(aggregationId)).singleGroupingSet(groupingKey).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.filter(new PlanNodeId(filterId), IrExpressions.not((Metadata)this.ruleTester.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, "filterInput"))), (PlanNode)p.tableScan(tableScan -> tableScan.setNodeId(new PlanNodeId(aggregationSourceId)).setTableHandle(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester)).setSymbols((List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol, (Object)groupingKey, (Object)filterInput)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE, (Object)groupingKey, (Object)GROUPING_KEY_COLUMN_HANDLE, (Object)filterInput, (Object)GROUPING_KEY2_COLUMN_HANDLE))))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"final_output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output1")), (Object)"final_output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2")), (Object)"group_by_key", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "left_groupingKey"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("left_groupingKey", "right_groupingKey").left(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("left_groupingKey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("output1"), PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input1Symbol")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter(IrExpressions.not((Metadata)this.ruleTester.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "left_filterInput"))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1Symbol", (Object)COLUMN_1, (Object)"left_groupingKey", (Object)GROUPING_KEY_COLUMN, (Object)"left_filterInput", (Object)GROUPING_KEY2_COLUMN))))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("right_groupingKey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("output2"), PlanMatchPattern.aggregationFunction("sum", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input2Symbol")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter(IrExpressions.not((Metadata)this.ruleTester.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "right_filterInput"))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input2Symbol", (Object)COLUMN_2, (Object)"right_groupingKey", (Object)GROUPING_KEY_COLUMN, (Object)"right_filterInput", (Object)GROUPING_KEY2_COLUMN))))))));
    }

    @Test
    public void testAutomaticDecisionForAggregationOnFilteredUnion() {
        String aggregationSourceId = "aggregationSourceId";
        String aggregationId = "aggregationId";
        String filterId = "filterId";
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol((Type)VarcharType.VARCHAR, "filterInput"), SymbolStatsEstimate.builder().setAverageRowSize(1.0).build()).build()).overrideStats(filterId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).build()).overrideStats(aggregationId, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input11Symbol = p.symbol("input1_1Symbol", (Type)BigintType.BIGINT);
            Symbol input12Symbol = p.symbol("input1_2Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol input21Symbol = p.symbol("input2_1Symbol", (Type)BigintType.BIGINT);
            Symbol input22Symbol = p.symbol("input2_2Symbol", (Type)BigintType.BIGINT);
            Symbol groupingKey = p.symbol("groupingKey", (Type)BigintType.BIGINT);
            Symbol groupingKey1 = p.symbol("groupingKey1", (Type)BigintType.BIGINT);
            Symbol groupingKey2 = p.symbol("groupingKey2", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.nodeId(new PlanNodeId(aggregationId)).singleGroupingSet(groupingKey).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)input1Symbol, (Object)input11Symbol).put((Object)input1Symbol, (Object)input12Symbol).put((Object)input2Symbol, (Object)input21Symbol).put((Object)input2Symbol, (Object)input22Symbol).put((Object)groupingKey, (Object)groupingKey1).put((Object)groupingKey, (Object)groupingKey2).build(), (List<PlanNode>)ImmutableList.of((Object)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input1_1Symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input11Symbol, (Object)input21Symbol, (Object)groupingKey1), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input11Symbol, (Object)COLUMN_1_HANDLE, (Object)input21Symbol, (Object)COLUMN_2_HANDLE, (Object)groupingKey1, (Object)GROUPING_KEY_COLUMN_HANDLE))), (Object)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input2_2Symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input12Symbol, (Object)input22Symbol, (Object)groupingKey2), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input12Symbol, (Object)COLUMN_1_HANDLE, (Object)input22Symbol, (Object)COLUMN_2_HANDLE, (Object)groupingKey2, (Object)GROUPING_KEY_COLUMN_HANDLE)))))));
        }).doesNotFire();
    }

    @Test
    public void testGlobalDistinctToSubqueries() {
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"final_output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output1")), (Object)"final_output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output1", PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input1Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1Symbol", (Object)COLUMN_1)))).right(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output2", PlanMatchPattern.aggregationFunction("sum", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input2Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input2Symbol", (Object)COLUMN_2)))))));
    }

    @Test
    public void testGlobalWith3DistinctToSubqueries() {
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol input3Symbol = p.symbol("input3Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output3", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input3Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol, (Object)input3Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE, (Object)input3Symbol, (Object)COLUMN_3_HANDLE))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"final_output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output1")), (Object)"final_output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2")), (Object)"final_output3", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output3"))), PlanMatchPattern.join(JoinType.INNER, join -> join.left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output1", PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input1Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1Symbol", (Object)COLUMN_1)))).right(PlanMatchPattern.join(JoinType.INNER, subJoin -> subJoin.left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output2", PlanMatchPattern.aggregationFunction("sum", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input2Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input2Symbol", (Object)COLUMN_2)))).right(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output3", PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input3Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input3Symbol", (Object)COLUMN_3)))))))));
    }

    @Test
    public void testGlobalWith4DistinctToSubqueries() {
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol input3Symbol = p.symbol("input3Symbol", (Type)BigintType.BIGINT);
            Symbol input4Symbol = p.symbol("input4Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output3", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input3Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output4", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input4Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol, (Object)input3Symbol, (Object)input4Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE, (Object)input3Symbol, (Object)COLUMN_3_HANDLE, (Object)input4Symbol, (Object)COLUMN_4_HANDLE))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"final_output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output1")), (Object)"final_output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2")), (Object)"final_output3", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output3")), (Object)"final_output4", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output4"))), PlanMatchPattern.join(JoinType.INNER, join -> join.left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output1", PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input1Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1Symbol", (Object)COLUMN_1)))).right(PlanMatchPattern.join(JoinType.INNER, subJoin -> subJoin.left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output2", PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input2Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input2Symbol", (Object)COLUMN_2)))).right(PlanMatchPattern.join(JoinType.INNER, subJoin2 -> subJoin2.left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output3", PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input3Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input3Symbol", (Object)COLUMN_3)))).right(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output4", PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input4Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input4Symbol", (Object)COLUMN_4)))))))))));
    }

    @Test
    public void testGlobal2DistinctOnTheSameInputToSubqueries() {
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output3", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"final_output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output1")), (Object)"final_output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2")), (Object)"final_output3", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output3"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output1", PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input1Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1Symbol", (Object)COLUMN_1)))).right(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"output2", PlanMatchPattern.aggregationFunction("sum", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input2Symbol"))), (Object)"output3", PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input2Symbol")))), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input2Symbol", (Object)COLUMN_2)))))));
    }

    @Test
    public void testGroupByWithDistinctToSubqueries() {
        String aggregationNodeId = "aggregationNodeId";
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").overrideStats(aggregationNodeId, PlanNodeStatsEstimate.builder().setOutputRowCount(100000.0).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol groupingKey = p.symbol("groupingKey", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.nodeId(new PlanNodeId(aggregationNodeId)).singleGroupingSet(groupingKey).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input1Symbol, (Object)input2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input1Symbol, (Object)COLUMN_1_HANDLE, (Object)input2Symbol, (Object)COLUMN_2_HANDLE, (Object)groupingKey, (Object)GROUPING_KEY_COLUMN_HANDLE))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"final_output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output1")), (Object)"final_output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2")), (Object)"group_by_key", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "left_groupingKey"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("left_groupingKey", "right_groupingKey").left(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("left_groupingKey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("output1"), PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input1Symbol")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1Symbol", (Object)COLUMN_1, (Object)"left_groupingKey", (Object)GROUPING_KEY_COLUMN)))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("right_groupingKey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("output2"), PlanMatchPattern.aggregationFunction("sum", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input2Symbol")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input2Symbol", (Object)COLUMN_2, (Object)"right_groupingKey", (Object)GROUPING_KEY_COLUMN)))))));
    }

    @Test
    public void testGroupByWithDistinctOverUnionToSubqueries() {
        String aggregationNodeId = "aggregationNodeId";
        this.ruleTester.assertThat((Rule<?>)TestMultipleDistinctAggregationsToSubqueries.newMultipleDistinctAggregationsToSubqueries(this.ruleTester)).setSystemProperty("distinct_aggregations_strategy", "split_to_subqueries").overrideStats(aggregationNodeId, PlanNodeStatsEstimate.builder().setOutputRowCount(100000.0).build()).on(p -> {
            Symbol input1Symbol = p.symbol("input1Symbol", (Type)BigintType.BIGINT);
            Symbol input11Symbol = p.symbol("input1_1Symbol", (Type)BigintType.BIGINT);
            Symbol input12Symbol = p.symbol("input1_2Symbol", (Type)BigintType.BIGINT);
            Symbol input2Symbol = p.symbol("input2Symbol", (Type)BigintType.BIGINT);
            Symbol input21Symbol = p.symbol("input2_1Symbol", (Type)BigintType.BIGINT);
            Symbol input22Symbol = p.symbol("input2_2Symbol", (Type)BigintType.BIGINT);
            Symbol groupingKey = p.symbol("groupingKey", (Type)BigintType.BIGINT);
            Symbol groupingKey1 = p.symbol("groupingKey1", (Type)BigintType.BIGINT);
            Symbol groupingKey2 = p.symbol("groupingKey2", (Type)BigintType.BIGINT);
            return p.aggregation(builder -> builder.nodeId(new PlanNodeId(aggregationNodeId)).singleGroupingSet(groupingKey).addAggregation(p.symbol("output1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input1Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input2Symbol"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)input1Symbol, (Object)input11Symbol).put((Object)input1Symbol, (Object)input12Symbol).put((Object)input2Symbol, (Object)input21Symbol).put((Object)input2Symbol, (Object)input22Symbol).put((Object)groupingKey, (Object)groupingKey1).put((Object)groupingKey, (Object)groupingKey2).build(), (List<PlanNode>)ImmutableList.of((Object)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input1_1Symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input11Symbol, (Object)input21Symbol, (Object)groupingKey1), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input11Symbol, (Object)COLUMN_1_HANDLE, (Object)input21Symbol, (Object)COLUMN_2_HANDLE, (Object)groupingKey1, (Object)GROUPING_KEY_COLUMN_HANDLE))), (Object)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input2_2Symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (PlanNode)p.tableScan(TestMultipleDistinctAggregationsToSubqueries.testTableHandle(this.ruleTester), (List<Symbol>)ImmutableList.of((Object)input12Symbol, (Object)input22Symbol, (Object)groupingKey2), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)input12Symbol, (Object)COLUMN_1_HANDLE, (Object)input22Symbol, (Object)COLUMN_2_HANDLE, (Object)groupingKey2, (Object)GROUPING_KEY_COLUMN_HANDLE)))))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"final_output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output1")), (Object)"final_output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2")), (Object)"group_by_key", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "left_groupingKey"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("left_groupingKey", "right_groupingKey").left(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("left_groupingKey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("output1"), PlanMatchPattern.aggregationFunction("count", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input1Symbol1")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.union(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input1_1_1Symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1_1_1Symbol", (Object)COLUMN_1, (Object)"input2_1_1Symbol", (Object)COLUMN_2, (Object)"left_groupingKey1", (Object)GROUPING_KEY_COLUMN))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input2_2_1Symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1_2_1Symbol", (Object)COLUMN_1, (Object)"input2_2_1Symbol", (Object)COLUMN_2, (Object)"left_groupingKey2", (Object)GROUPING_KEY_COLUMN)))).withAlias("input1Symbol1", (RvalueMatcher)new SetOperationOutputMatcher(0)).withAlias("input2Symbol1", (RvalueMatcher)new SetOperationOutputMatcher(1)).withAlias("left_groupingKey", (RvalueMatcher)new SetOperationOutputMatcher(2)))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("right_groupingKey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("output2"), PlanMatchPattern.aggregationFunction("sum", true, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("input2Symbol2")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.union(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input1_1_2Symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1_1_2Symbol", (Object)COLUMN_1, (Object)"input2_1_2Symbol", (Object)COLUMN_2, (Object)"right_groupingKey1", (Object)GROUPING_KEY_COLUMN))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input2_2_2Symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan(TABLE_SCHEMA.getTableName(), (Map<String, String>)ImmutableMap.of((Object)"input1_2_2Symbol", (Object)COLUMN_1, (Object)"input2_2_2Symbol", (Object)COLUMN_2, (Object)"right_groupingKey2", (Object)GROUPING_KEY_COLUMN)))).withAlias("input1Symbol2", (RvalueMatcher)new SetOperationOutputMatcher(0)).withAlias("input2Symbol2", (RvalueMatcher)new SetOperationOutputMatcher(1)).withAlias("right_groupingKey", (RvalueMatcher)new SetOperationOutputMatcher(2)))))));
    }

    private static MultipleDistinctAggregationsToSubqueries newMultipleDistinctAggregationsToSubqueries(RuleTester ruleTester) {
        return new MultipleDistinctAggregationsToSubqueries(new TaskCountEstimator(() -> Integer.MAX_VALUE), ruleTester.getMetadata());
    }

    private static TableHandle testTableHandle(RuleTester ruleTester) {
        return new TableHandle(ruleTester.getCurrentCatalogHandle(), (ConnectorTableHandle)new MockConnectorTableHandle(TABLE_SCHEMA, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty()), (ConnectorTransactionHandle)TestingTransactionHandle.create());
    }

    private static RuleTester tester(boolean allowSplittingReadIntoMultipleSubQueries) {
        PlanTester planTester = PlanTester.create((Session)MOCK_SESSION);
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder().withAllowSplittingReadIntoMultipleSubQueries(allowSplittingReadIntoMultipleSubQueries).withGetTableHandle((connectorSession, schemaTableName) -> new MockConnectorTableHandle((SchemaTableName)schemaTableName)).withGetColumns(schemaTableName -> ALL_COLUMNS);
        planTester.createCatalog(MOCK_CATALOG, (ConnectorFactory)builder.build(), (Map)ImmutableMap.of());
        return new RuleTester(planTester);
    }
}

