/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushAggregationThroughOuterJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestPushAggregationThroughOuterJoin
extends BaseRuleTest {
    public TestPushAggregationThroughOuterJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushesAggregationThroughLeftJoin() {
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), (PlanNode)p.values(p.symbol("COL2", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("COL1", (Type)BigintType.BIGINT), p.symbol("COL2", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL2", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.symbol("AVG", (Type)DoubleType.DOUBLE), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL2"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("COL1", (Type)BigintType.BIGINT)))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"COL1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "COL1")), (Object)"COALESCE", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)DoubleType.DOUBLE, "AVG"), (Expression)new Reference((Type)DoubleType.DOUBLE, "AVG_NULL"), new Expression[0]))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.join(JoinType.LEFT, leftJoinBuilder -> leftJoinBuilder.equiCriteria("COL1", "COL2").left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL1", (Object)0))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("COL2"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("AVG"), PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"COL2"))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL2", (Object)0)))))).right(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("AVG_NULL"), PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"null_literal"))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"null_literal", (Object)0)))))));
    }

    @Test
    public void testPushesAggregationThroughRightJoin() {
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.RIGHT, (PlanNode)p.values(p.symbol("COL2", (Type)BigintType.BIGINT)), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("COL2", (Type)BigintType.BIGINT), p.symbol("COL1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL2", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.symbol("AVG", (Type)DoubleType.DOUBLE), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL2"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("COL1", (Type)BigintType.BIGINT)))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"COALESCE", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)DoubleType.DOUBLE, "AVG"), (Expression)new Reference((Type)DoubleType.DOUBLE, "AVG_NULL"), new Expression[0])), (Object)"COL1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "COL1"))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.join(JoinType.RIGHT, leftJoinBuilder -> leftJoinBuilder.equiCriteria("COL2", "COL1").left(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("COL2"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("AVG"), PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"COL2"))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL2", (Object)0)))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL1", (Object)0))))).right(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("AVG_NULL"), PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"null_literal"))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"null_literal", (Object)0)))))));
    }

    @Test
    public void testPushesAggregationWithMask() {
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), (PlanNode)p.values(p.symbol("COL2", (Type)BigintType.BIGINT), p.symbol("MASK", (Type)BooleanType.BOOLEAN)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("COL1", (Type)BigintType.BIGINT), p.symbol("COL2", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL2", (Type)BigintType.BIGINT), (Object)p.symbol("MASK", (Type)BooleanType.BOOLEAN)), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.symbol("AVG", (Type)DoubleType.DOUBLE), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL2"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), p.symbol("MASK", (Type)BooleanType.BOOLEAN)).singleGroupingSet(p.symbol("COL1", (Type)BigintType.BIGINT)))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"COL1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "COL1")), (Object)"COALESCE", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)DoubleType.DOUBLE, "AVG"), (Expression)new Reference((Type)DoubleType.DOUBLE, "AVG_NULL"), new Expression[0]))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.join(JoinType.LEFT, leftJoinBuilder -> leftJoinBuilder.equiCriteria("COL1", "COL2").left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL1", (Object)0))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("COL2"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("AVG"), PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"COL2"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"MASK"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL2", (Object)0, (Object)"MASK", (Object)1)))))).right(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("AVG_NULL"), PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"null_literal"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"MASK_NULL"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"null_literal", (Object)0, (Object)"MASK_NULL", (Object)1)))))));
    }

    @Test
    public void testPushCountAllAggregation() {
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), (PlanNode)p.values(p.symbol("COL2", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("COL1", (Type)BigintType.BIGINT), p.symbol("COL2", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL1", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL2", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.symbol("COUNT", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).singleGroupingSet(p.symbol("COL1", (Type)BigintType.BIGINT)))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"COL1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "COL1")), (Object)"COALESCE", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "COUNT"), (Expression)new Reference((Type)BigintType.BIGINT, "COUNT_NULL"), new Expression[0]))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.join(JoinType.LEFT, leftJoinBuilder -> leftJoinBuilder.equiCriteria("COL1", "COL2").left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL1", (Object)0))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("COL2"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("COUNT"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"COL2", (Object)0)))))).right(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("COUNT_NULL"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"null_literal", (Object)0)))))));
    }

    @Test
    public void testDoesNotFireWhenMultipleGroupingSets() {
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1"), (Object)p.symbol("COL2")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL3")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("COL1"), p.symbol("COL3"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL3")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.symbol("COUNT"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)p.symbol("COL1"), (Object)p.symbol("COL2")), (int)2, (Set)ImmutableSet.of())))).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenNotDistinct() {
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)10L)), (Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)11L)))), (PlanNode)p.values(new Symbol((Type)BigintType.BIGINT, "COL2")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "COL1"), new Symbol((Type)BigintType.BIGINT, "COL2"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(new Symbol((Type)DoubleType.DOUBLE, "AVG"), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL2"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(new Symbol((Type)BigintType.BIGINT, "COL1")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.project(Assignments.builder().putIdentity(p.symbol("COL1", (Type)BigintType.BIGINT)).build(), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(p.symbol("COL1"), p.symbol("unused")).source((PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1"), (Object)p.symbol("unused")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)10L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)10L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))))), (PlanNode)p.values(p.symbol("COL2")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("COL1"), p.symbol("COL2"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(p.symbol("AVG", (Type)DoubleType.DOUBLE), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "COL2"))), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE)).singleGroupingSet(p.symbol("COL1")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenGroupingOnInner() {
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), (PlanNode)p.values(new Symbol((Type)BigintType.BIGINT, "COL2"), new Symbol((Type)BigintType.BIGINT, "COL3")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "COL1"), new Symbol((Type)BigintType.BIGINT, "COL2"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(new Symbol((Type)DoubleType.DOUBLE, "AVG"), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL2"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(new Symbol((Type)BigintType.BIGINT, "COL1"), new Symbol((Type)BigintType.BIGINT, "COL3")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenAggregationDoesNotHaveSymbols() {
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL2")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)20L)))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "COL1"), new Symbol((Type)BigintType.BIGINT, "COL2"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(new Symbol((Type)BigintType.BIGINT, "SUM"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL1"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(new Symbol((Type)BigintType.BIGINT, "COL1")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenAggregationOnMultipleSymbolsDoesNotHaveSomeSymbols() {
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL2"), (Object)p.symbol("COL3")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)20L), (Object)new Constant((Type)BigintType.BIGINT, (Object)30L)))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "COL1"), new Symbol((Type)BigintType.BIGINT, "COL2"))), (List<Symbol>)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "COL1")), (List<Symbol>)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(new Symbol((Type)BigintType.BIGINT, "MIN_BY"), PlanBuilder.aggregation("min_by", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL2"), (Object)new Reference((Type)BigintType.BIGINT, "COL1"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).singleGroupingSet(new Symbol((Type)BigintType.BIGINT, "COL1")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushAggregationThroughOuterJoin()).on(p -> p.aggregation(ab -> ab.source((PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL1")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("COL2"), (Object)p.symbol("COL3")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)20L), (Object)new Constant((Type)BigintType.BIGINT, (Object)30L)))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, "COL1"), new Symbol((Type)BigintType.BIGINT, "COL2"))), (List<Symbol>)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "COL1")), (List<Symbol>)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "COL2")), Optional.empty(), Optional.empty(), Optional.empty())).addAggregation(new Symbol((Type)BigintType.BIGINT, "SUM"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL2"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(new Symbol((Type)BigintType.BIGINT, "MIN_BY"), PlanBuilder.aggregation("min_by", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL2"), (Object)new Reference((Type)BigintType.BIGINT, "COL3"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addAggregation(new Symbol((Type)BigintType.BIGINT, "MAX_BY"), PlanBuilder.aggregation("max_by", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "COL2"), (Object)new Reference((Type)BigintType.BIGINT, "COL1"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).singleGroupingSet(new Symbol((Type)BigintType.BIGINT, "COL1")))).doesNotFire();
    }
}

