/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedDistinctAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedDistinctAggregationWithProjection
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    public TestTransformCorrelatedDistinctAggregationWithProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedDistinctAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithNonDistinctAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedDistinctAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("b")}), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).singleGroupingSet(p.symbol("b")))))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedDistinctAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)Booleans.TRUE, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("x", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)100L)))), (PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "corr")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "corr")), (Object)"x", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)100L))))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "corr"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("a", "b")))))));
    }
}

