/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestExpressions {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testBooleanExpressionInCase() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 IS NULL WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 IS NOT NULL WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 BETWEEN 0 AND 2 WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 NOT BETWEEN 0 AND 2 WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 IN (1, 2) WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 NOT IN (1, 2) WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 = 1 WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 = 2 WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 < 2 WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 > 2 WHEN true THEN 10 ELSE 20 END"))).matches("VALUES 20");
    }

    @Test
    public void testInShortCircuit() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT IF(3 IN (2, 4, 3, 5 / 0), 1e0, x + x) FROM (VALUES rand()) t(x)"))).matches("VALUES 1e0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 3 IN (2, 4, 3, 5 / 0)"))).failure().hasMessage("Division by zero");
    }

    @Test
    public void testInlineNullBind() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT try(k) FROM (SELECT null) t(k)"))).matches("VALUES null");
    }
}

