/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestNumericalStability {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testVariance() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(VAR_SAMP(x + exp(30))/VAR_SAMP(x) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)"))).matches("VALUES 1.00");
    }

    @Test
    public void testCovariance() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(COVAR_SAMP(x + exp(30), x + exp(30))/VAR_SAMP(x) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)"))).matches("VALUES 1.00");
    }

    @Test
    public void testCorrelation() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(CORR(x + exp(30), x + exp(30)) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)"))).matches("VALUES 1.00");
    }

    @Test
    public void testRegressionSlope() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(REGR_SLOPE((x + exp(30)) * 5 + 8, x + exp(30)) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)"))).matches("VALUES 5.00");
    }

    @Test
    public void testRegressionIntercept() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(REGR_INTERCEPT((x + exp(20)) * 5 + 8, x + exp(20)) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)"))).matches("VALUES 8.00");
    }
}

